<?php
/**
 * tdblu Theme Customizer
 *
 * @package tdblu
 * @since tdblu 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 * @since tdblu 1.0
 */
function tdblu_customize_register( $wp_customize ) {
	$wp_customize->add_setting( 'tdblu_website_style', array(
        'default' => '',
    ) );
 
	$wp_customize->add_control( 'tdblu_website_style', array(
        'type' => 'select',
        'label' => 'Website Style:',
        'section' => 'colors',
        'choices' => array(
            '' => 'Default',
            'orange' => 'Orange',
            'green' => 'Green',
            'red' => 'Red',
            'purple' => 'Purple',
        ),
        'priority' => 1
    ));
 
}
add_action( 'customize_register', 'tdblu_customize_register');