<?php
/**
 * The Header for theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package tdBlu
 * @since tdBlu 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width" />
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
	<![endif]-->

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php $website_style = get_theme_mod( 'tdblu_website_style' ); ?>

<div id="page" class="hfeed site <?php echo $website_style; ?>">

	<?php do_action( 'tdblu_before_header' ); ?>
	
	<header id="masthead" class="site-header" role="banner">
	
		<div class="brand-box">
			<div class="row">
				<div class="twelve columns">
					<hgroup>
						<h1 class="site-title"><a class="name" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
					</hgroup>
				</div>
			</div>
		</div>
	
		
		
		<nav role="navigation" class="site-navigation main-navigation">
			<div class="row">
				<div class="twelve columns">
					<h1 class="assistive-text"><?php _e( 'Menu', 'tdblu' ); ?></h1>
					<?php if ( has_nav_menu( 'primary' ) ) { ?>
						<?php wp_nav_menu( array( 'container' => 'ul', 'menu_class' => 'nav-bar', 'theme_location' => 'primary') ); ?>
					<?php } else { ?>
						<ul class="nav-bar">
							<li><a href="<?php echo home_url(); ?>/">Home</a></li>
							<?php 
								wp_list_pages('title_li=' ); 
							?>
						</ul>
					<?php } ?>
				</div>
			</div>
		</nav><!-- .site-navigation .main-navigation -->

		
	</header><!-- #masthead .site-header -->

	<div id="main" class="site-main row">
