<?php
/**
 * tdBlu functions and definitions
 *
 * @package tdBlu
 * @since tdBlu 1.0
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * @since tdBlu 1.0
 */
if ( ! isset( $content_width ) )
	$content_width = 640; /* pixels */

if ( ! function_exists( 'tdblu_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * @since tdBlu 1.0
 */
function tdblu_setup() {
	
	/**
	 * Translation
	 */
	load_theme_textdomain( 'tdblu', get_template_directory() . '/languages' );

	/**
	 * Custom template tags for this theme.
	 */
	require( get_template_directory() . '/inc/template-tags.php' );

	/**
	 * Custom functions that act independently of the theme templates
	 */
	require( get_template_directory() . '/inc/extras.php' );
	
	/**
	 * Customizer additions
	 */
	require( get_template_directory() . '/inc/customizer.php' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'tdblu' ),
	) );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'audio', 'gallery', 'image', 'video', 'quote', 'link' ) );
}
endif; // tdblu_setup
add_action( 'after_setup_theme', 'tdblu_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 *
 * @since tdBlu 1.0
 */
function tdblu_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Sidebar', 'tdblu' ),
		'id' => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer #1', 'tdblu' ),
		'id' => 'footer-widget-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer #2', 'tdblu' ),
		'id' => 'footer-widget-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer #3', 'tdblu' ),
		'id' => 'footer-widget-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer #4', 'tdblu' ),
		'id' => 'footer-widget-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
}
add_action( 'widgets_init', 'tdblu_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function tdblu_scripts() {
	wp_enqueue_style( 'googlefonts', '//fonts.googleapis.com/css?family=Lato:400,700|Quattrocento:400,700' );
	wp_enqueue_style( 'foundation', get_template_directory_uri() . '/css/foundation.min.css' );
	wp_enqueue_style( 'style', get_stylesheet_uri() );
	
	wp_enqueue_script( 'small-menu', get_template_directory_uri() . '/js/small-menu.js', array( 'jquery' ), '20120206', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}
	
	wp_enqueue_script( 'foundation-script', get_template_directory_uri() . '/js/foundation.min.js', array( 'jquery' ), '1', true  ); 
	wp_enqueue_script( 'theme-script', get_template_directory_uri() . '/js/tdblu.js', array( 'jquery' ), '1', true  );
}
add_action( 'wp_enqueue_scripts', 'tdblu_scripts' );

/**
 * Add custom class to Edit Link
 */
function tdblu_custom_edit_post_link($output) {
    $output = str_replace('class="post-edit-link"', 'class="post-edit-link secondary button"', $output);
	return $output;
}
add_filter('edit_post_link', 'tdblu_custom_edit_post_link');

/**
 * Customize our Comment Form
 */
 function tdblu_comment_form_top() {
 	echo '<fieldset>';
 }
 add_action( 'comment_form_top', 'tdblu_comment_form_top' );
 
 function tdblu_comment_form_bottom() {
 	echo '</fieldset>';
 }
 add_action( 'comment_form', 'tdblu_comment_form_bottom' );
 
/**
*	Rename Sticky Post Class
*	@since tdblu 1.0
*/
function tdblu_post_names($classes) {
	$classes = str_replace("sticky", "sticky-post", $classes);
	return $classes;
}
add_filter('post_class','tdblu_post_names');

/**
 * Customize excerpts more tag
 */
function tdblu_excerpt_more($more) {
       global $post;
	return '... <a class="moretag" href="'. get_permalink($post->ID) . '"> Read More</a>';
}
add_filter('excerpt_more', 'tdblu_excerpt_more');