<?php
/**
 * @package tdBlu
 * @since tdBlu 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<div class="header-image post">
			<?php 
			
			if(has_post_thumbnail()) {
				echo '
						<a class="image-preview" href="'.post_permalink().'">
							<img src="'.wp_get_attachment_url( get_post_thumbnail_id() ).'" alt="'.get_the_title().'">
							<span class="image-preview-icon"><i class="genericon genericon-link"></i></span>
						</a>
					';
			} else {
				echo '<div style="margin-bottom: 60px"></div>';
			}
			
			?>
		</div>
	
		<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'tdblu' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

		<?php if ( 'post' == get_post_type() ) : ?>
			<div class="entry-meta">
				<?php tdblu_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
		
	</header><!-- .entry-header -->

	<?php if ( is_search() ) : /* Only display Excerpts for Search */ ?>
	
		<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		
	<?php else : ?>
	
		<div class="entry-content">
			<?php the_content( __( 'Continue reading &rarr;', 'tdblu' ) ); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'tdblu' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		
	<?php endif; ?>

	<footer class="entry-meta bottom">
		<div class="row">
  			<div class="twelve columns">
    			<?php if ( 'post' == get_post_type() ) : /* Hide category and tag text for pages on Search */ ?>
					<?php
						/* translators: used between list items, there is a space after the comma */
						$categories_list = get_the_category_list( __( ' ', 'tdblu' ) );
						if ( $categories_list && tdblu_categorized_blog() ) :
					?>
					
					<span class="cat-links"><i class="genericon genericon-category"></i>
						<?php printf( __( '%1$s', 'tdblu' ), $categories_list ); ?>
					</span>
					
					<?php endif; /* End if categories */ ?>
		
					<?php
						/* translators: used between list items, there is a space after the comma */
						$tags_list = get_the_tag_list( '', __( ' ', 'tdblu' ) );
						if ( $tags_list ) :
					?>
		
					<span class="tags-links"><i class="genericon genericon-tag"></i>
						<?php printf( __( '%1$s', 'tdblu' ), $tags_list ); ?>
					</span>
					<?php endif; /* End if $tags_list */ ?>
				<?php endif; /*  End if 'post' == get_post_type() */ ?>
  			</div>
		</div>

	</footer><!-- .entry-meta -->
	
	<div class="edit-link">
    	<?php edit_post_link( __( 'Edit', 'tdblu' ), '', '' ); ?>
  	</div>
</article><!-- #post-<?php the_ID(); ?> -->
