<?php
/**
 * @package tdBlu
 * @since tdBlu 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
	<header class="entry-header">
		<div class="header-image post">
			<?php 
			
			if(has_post_thumbnail()) {
				echo '<img src="'.wp_get_attachment_url( get_post_thumbnail_id() ).'" alt="'.get_the_title().'">';
			} else {
				echo '<div style="margin-bottom: 60px"></div>';
			}
			
			?>
		</div>	
	
		<h2 class="entry-title"><?php the_title(); ?></h2>

		<div class="entry-meta">
			<?php tdblu_posted_on(); ?>
		</div><!-- .entry-meta -->
		
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>
		<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'tdblu' ), 'after' => '</div>' ) ); ?>
	</div><!-- .entry-content -->

	<footer class="entry-meta bottom">
		
		<div class="row">  			
  			<div class="twelve columns">
  				<?php
					/* translators: used between list items, there is a space after the comma */
					$category_list = get_the_category_list( __( ' ', 'tdblu' ) );
		
					/* translators: used between list items, there is a space after the comma */
					$tag_list = get_the_tag_list( '', __( ' ', 'tdblu' ) );
		
					if ( ! tdblu_categorized_blog() ) {
						// This blog only has 1 category so we just need to worry about tags in the meta text
						if ( '' != $tag_list ) {
							$meta_text = __( 'This entry was tagged <span class="entry-tags">%2$s</span>', 'tdblu' );
						} else {
							$meta_text = __( '', 'tdblu' );
						}
		
					} else {
						// But this blog has loads of categories so we should probably display them here
						if ( '' != $tag_list ) {
							$meta_text = __( 'This entry was posted in <span class="entry-cats">%1$s</span> and tagged <span class="entry-tags">%2$s</span>', 'tdblu' );
						} else {
							$meta_text = __( 'This entry was posted in <span class="entry-cats">%1$s</span>', 'tdblu' );
						}
		
					} // end check for categories on this blog
		
					printf(
						$meta_text,
						$category_list,
						$tag_list
					);
				?>
  			</div>
  		</div>

	</footer><!-- .entry-meta -->
	
	<div class="edit-link">
    	<?php edit_post_link( __( 'Edit', 'tdblu' ), '', '' ); ?>
  	</div>
	
</article><!-- #post-<?php the_ID(); ?> -->
