<?php
/**
 * The template used for displaying audio content
 *
 * @package tdblu
 * @since tdblu 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('index-page'); ?>>
	<header class="entry-header">
		<div class="header-image post">
			<?php 
				
				if(has_post_thumbnail()) {
					echo '
							<a class="image-preview" href="'.post_permalink().'">
								<img src="'.wp_get_attachment_url( get_post_thumbnail_id() ).'" alt="'.get_the_title().'">
								<span class="image-preview-icon"><i class="genericon genericon-audio"></i></span>
							</a>
						';
				}
				
			?>
		</div>
	
	</header>

	<footer class="entry-meta bottom">
		
		<div class="row">
  			<div class="nine columns meta-info">
  				<h4 class="entry-title"><a href="<?php echo post_permalink(); ?>"><?php the_title(); ?></a></h4>
  				<div class="entry-meta">
  					<?php tdblu_posted_on(); ?>
  				</div>
  			</div>
  			
  			<div class="three columns">
  				<div class="post-format-icon-box">
					<span class="post-format-icon"><a href="<?php echo post_permalink(); ?>" class="genericon genericon-audio"></a></span>
  				</div>
  			</div>
  		</div>

	</footer><!-- .entry-meta -->

	<div class="edit-link">
    	<?php edit_post_link( __( 'Edit', 'tdblu' ), '', '' ); ?>
  	</div>
</article><!-- #post-<?php the_ID(); ?> -->