<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package tdBlu
 * @since tdBlu 1.0
 */

get_header(); ?>

	<div id="primary" class="content-area twelve columns">
		<div id="content" class="site-content" role="main">

			<article id="post-0" class="post error404 not-found">
				<header class="entry-header">
					<h1 class="entry-title"><?php _e( 'Oops! That page can&rsquo;t be found.', 'tdblu' ); ?></h1>
				</header><!-- .entry-header -->

				<div class="entry-content">
					<p class="sub-info"><?php _e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'tdblu' ); ?></p>
					
					<div class="row">
						<div class="nine columns centered">
							<?php get_search_form(); ?>
						</div>
					</div>
					
					<div class="row">
						<div class="four columns">
							<?php the_widget( 'WP_Widget_Recent_Posts', '', 'before_title=<h4>&after_title=</h4>' ); ?>
						</div>
						
						<div class="four columns">
							<div class="widget">
								<h4 class="widgettitle"><?php _e( 'Most Used Categories', 'tdblu' ); ?></h4>
								<ul>
								<?php wp_list_categories( array( 'orderby' => 'count', 'order' => 'DESC', 'show_count' => 1, 'title_li' => '', 'number' => 10 ) ); ?>
								</ul>
							</div><!-- .widget -->
						</div>
						
						<div class="four columns">
							<?php
								/* translators: %1$s: smilie */
								$archive_content = '<p>' . sprintf( __( 'Try looking in the monthly archives. %1$s', 'tdblu' ), convert_smilies( ':)' ) ) . '</p>';
								the_widget( 'WP_Widget_Archives', 'dropdown=1', "before_title=<h4>&after_title=</h4>$archive_content" );
							?>
						</div>
					</div>

					<div class="row">
						<div class="twelve columns">
							<?php the_widget( 'WP_Widget_Tag_Cloud', 'title= ', '' ); ?>
						</div>
					</div>


				</div><!-- .entry-content -->
			</article><!-- #post-0 .post .error404 .not-found -->

		</div><!-- #content .site-content -->
	</div><!-- #primary .content-area -->

<?php get_footer(); ?>