<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Swimwear Shop
 */

get_header(); ?>

<div id="content" >

  <?php
    $swimwear_shop_hidepageboxes = get_theme_mod('swimwear_shop_slider', false);
    $swimwear_shop_catData = get_theme_mod('swimwear_shop_slider_cat');
    if ($swimwear_shop_hidepageboxes && $swimwear_shop_catData) { ?>
    <section id="slider-cat">
      <div class="slideimg">
        <div class="container sliderbox">
            <div class="owl-carousel m-0 owl-theme">
                <?php
                $swimwear_shop_catData = get_theme_mod('swimwear_shop_slider_category', ''); 
                $swimwear_shop_page_query = new WP_Query(
                    array(
                        'category_name' => esc_attr($swimwear_shop_catData),
                        'posts_per_page' => -1, 
                    )
                );
                while ($swimwear_shop_page_query->have_posts()) : $swimwear_shop_page_query->the_post(); ?>
                    <div class="row m-0">
                        <div class="col-lg-7 col-md-7 col-12 align-self-center mb-md-0 mb-2">
                            <div class="text-content">
                                <?php if(get_theme_mod('swimwear_shop_slider_small_title') != ''){ ?>
                                    <p class="slider-smalltitle text-uppercase"><?php echo esc_html(get_theme_mod('swimwear_shop_slider_small_title','swimwear-shop')); ?></p>
                                <?php } ?>
                                <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                <?php if(get_theme_mod('swimwear_shop_slider_subhead') != ''){ ?>
                                    <p class="slider-subhead"><?php echo esc_html(get_theme_mod('swimwear_shop_slider_subhead','swimwear-shop')); ?></p>
                                <?php } ?>
                                <?php
                                $swimwear_shop_trimexcerpt  = get_the_excerpt();
                                $swimwear_shop_shortexcerpt = wp_trim_words($swimwear_shop_trimexcerpt, 25);
                                echo '<p class="slider-content">' . esc_html($swimwear_shop_shortexcerpt) . '</p>';
                                ?>
                                <div class="sliderbtn mt-3">
                                    <?php 
                                    $swimwear_shop_button_text = get_theme_mod('swimwear_shop_button_text', 'View All Collection');
                                    $swimwear_shop_button_link_slider = get_theme_mod('swimwear_shop_button_link_slider', get_permalink()); 
                                    if ($swimwear_shop_button_text || !empty($swimwear_shop_button_link_slider)) { ?>
                                        <?php if(get_theme_mod('swimwear_shop_button_text', 'View All Collection') != ''){ ?>
                                        <div class="slide-btn">
                                            <a href="<?php echo esc_url($swimwear_shop_button_link_slider); ?>" class="button redmor">
                                                <?php echo esc_html($swimwear_shop_button_text); ?>
                                                <span class="screen-reader-text"><?php echo esc_html($swimwear_shop_button_text); ?></span>
                                            </a>
                                        </div>
                                        <?php } ?>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-12 align-self-center slider-img-col">
                            <div class="imagebox">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full');
                                } else { ?>
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider.png" alt="<?php echo esc_attr( 'slider', 'swimwear-shop'); ?>"/>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>
            </div>
        </div>
      </div>
    </section>
  <?php } ?>

<?php
    $swimwear_shop_product_selling = get_theme_mod('swimwear_shop_product_selling', false);
    $swimwear_shop_hot_products_cat = get_theme_mod('swimwear_shop_hot_products_cat');
    if( $swimwear_shop_product_selling && $swimwear_shop_hot_products_cat){
  ?>
  <section id="trending_product" class="my-5 mx-md-0 mx-3">
    <div class="container">
      <?php if (class_exists('woocommerce')) {
      $swimwear_shop_args = array(
          'post_type' => 'product',
          'posts_per_page' => 50,
          'product_cat' => get_theme_mod('swimwear_shop_hot_products_cat'),
          'order' => 'ASC'
      );
      $swimwear_shop_loop = new WP_Query($swimwear_shop_args);
      if ($swimwear_shop_loop->have_posts()) : ?>
        <div class="owl-carousel owl-theme">
            <?php while ($swimwear_shop_loop->have_posts()) : $swimwear_shop_loop->the_post(); global $product;
                $swimwear_shop_start_date = get_post_meta(get_the_ID(), '_sale_price_dates_from', true);
                $swimwear_shop_end_date = get_post_meta(get_the_ID(), '_sale_price_dates_to', true);

                $swimwear_shop_end_date_final = '';
                if ($swimwear_shop_end_date) {
                    $swimwear_shop_end_date_final = date('Y-m-d', $swimwear_shop_end_date);
                }
            ?>
          <div class="item product-box">
              <div class="row">
                  <div class="col-lg-5 col-md-5 product-img pe-lg-5 mb-3 align-self-center">
                    <?php 
                      if (has_post_thumbnail($swimwear_shop_loop->post->ID)) {
                          echo wp_kses_post(get_the_post_thumbnail($swimwear_shop_loop->post->ID, 'shop_catalog'));
                      } else {
                          $swimwear_shop_placeholder_img_src = esc_url(get_template_directory_uri() . '/images/product-img.png');
                          echo '<img src="' . $swimwear_shop_placeholder_img_src . '" alt="Placeholder Image" />';
                      } 
                    ?>
                  </div>
                  <div class="col-lg-7 col-md-6 ps-lg-4 align-self-center">
                    <h2 class="product-text mb-2">
                      <a href="<?php echo esc_url(get_permalink($swimwear_shop_loop->post->ID)); ?>">
                        <?php the_title(); ?>
                      </a>
                    </h2>
                    <div class="prod-rate mb-3 d-flex">
                      <span class="price pe-4"><?php echo $product->get_price_html(); ?></span>
                      <span class="product-rating">
                        <?php if ($product->is_type('simple')) { woocommerce_template_loop_rating(); } ?>
                      </span>
                    </div>
                    <div class="product-description mb-3">
                      <?php
                        $content = get_the_content();
                        $excerpt = wp_trim_words($content, 90);
                        echo apply_filters('the_content', $excerpt);
                      ?>
                    </div>
                    <div class="product-timer" data-date="<?php echo esc_attr($swimwear_shop_end_date_final); ?>"></div>
                    <div class="the_timer"></div>
                  </div>
              </div>
          </div>
        <?php endwhile; ?>
      </div>
      <?php endif; wp_reset_postdata(); } ?>
    </div>
  </section>
<?php } ?>

</div>
<?php get_footer(); ?>
