// preloader
jQuery(window).on('load', function() {
  jQuery('#status').fadeOut();
  jQuery('#preloader').delay(350).fadeOut('slow');
  jQuery('body').delay(350).css({'overflow':'visible'});
})

// toggle button
jQuery(function($){
  $( '.toggle-nav button' ).click( function(e){
    $( 'body' ).toggleClass( 'show-main-menu' );
    var element = $( '.sidenav' );
    swimwear_shop_trapFocus( element );
  });

  $( '.close-button' ).click( function(e){
    $( '.toggle-nav button' ).click();
    $( '.toggle-nav button' ).focus();
  });
  $( document ).on( 'keyup',function(evt) {
    if ( $( 'body' ).hasClass( 'show-main-menu' ) && evt.keyCode == 27 ) {
      $( '.toggle-nav button' ).click();
      $( '.toggle-nav button' ).focus();
    }
  });
});

function swimwear_shop_trapFocus( element, namespace ) {
  var swimwear_shop_focusableEls = element.find( 'a, button' );
  var swimwear_shop_firstFocusableEl = swimwear_shop_focusableEls[0];
  var swimwear_shop_lastFocusableEl = swimwear_shop_focusableEls[swimwear_shop_focusableEls.length - 1];
  var KEYCODE_TAB = 9;

  swimwear_shop_firstFocusableEl.focus();

  element.keydown( function(e) {
    var isTabPressed = ( e.key === 'Tab' || e.keyCode === KEYCODE_TAB );

    if ( !isTabPressed ) {
      return;
    }

    if ( e.shiftKey ) /* shift + tab */ {
      if ( document.activeElement === swimwear_shop_firstFocusableEl ) {
        swimwear_shop_lastFocusableEl.focus();
        e.preventDefault();
      }
    } else /* tab */ {
      if ( document.activeElement === swimwear_shop_lastFocusableEl ) {
        swimwear_shop_firstFocusableEl.focus();
        e.preventDefault();
      }
    }
  });
}

jQuery(document).ready(function () {
  // Sticky Header
  jQuery(window).scroll(function () {
    var sticky = jQuery('.header-sticky'),
        scroll = jQuery(this).scrollTop();

    if (scroll >= 100) {
      sticky.addClass('header-fixed');
    } else {
      sticky.removeClass('header-fixed');
    }

    // Scroll to Top Button
    if (scroll > 0) {
      jQuery('#button').fadeIn();
    } else {
      jQuery('#button').fadeOut();
    }
  });

  jQuery('#button').click(function () {
    jQuery("html, body").animate({
      scrollTop: 0
    }, 600);
    return false;
  });

  swimwear_shop_search_focus();
});


// search
function swimwear_shop_search_focus() {

  /* First and last elements in the menu */
  var swimwear_shop_search_firstTab = jQuery('.serach_inner input[type="search"]');
  var swimwear_shop_search_lastTab  = jQuery('button.search-close'); /* Cancel button will always be last */

  jQuery(".search-open").click(function(e){
    e.preventDefault();
    e.stopPropagation();
    jQuery('body').addClass("search-focus");
    swimwear_shop_search_firstTab.focus();
  });

  jQuery("button.search-close").click(function(e){
    e.preventDefault();
    e.stopPropagation();
    jQuery('body').removeClass("search-focus");
    jQuery(".search-open").focus();
  });

  /* Redirect last tab to first input */
  swimwear_shop_search_lastTab.on('keydown', function (e) {
    if (jQuery('body').hasClass('search-focus'))
    if ((e.which === 9 && !e.shiftKey)) {
      e.preventDefault();
      swimwear_shop_search_firstTab.focus();
    }
  });

  /* Redirect first shift+tab to last input*/
  swimwear_shop_search_firstTab.on('keydown', function (e) {
    if (jQuery('body').hasClass('search-focus'))
    if ((e.which === 9 && e.shiftKey)) {
      e.preventDefault();
      swimwear_shop_search_lastTab.focus();
    }
  });

  /* Allow escape key to close menu */
  jQuery('.serach_inner').on('keyup', function(e){
    if (jQuery('body').hasClass('search-focus'))
    if (e.keyCode === 27 ) {
      jQuery('body').removeClass('search-focus');
      swimwear_shop_search_lastTab.focus();
    };
  });
}


// slider owl
jQuery(document).ready(function() {
  jQuery('#slider-cat .owl-carousel').owlCarousel({
    loop: true,
    margin: 0,
    nav:true,
    navText: ["<i class='fas fa-arrow-left'></i>", "<i class='fas fa-arrow-right'></i>"], 
    dots:false,
    rtl:false,
    items: 1,
    autoplay:true,
  })
});

// product 
jQuery(document).ready(function() { 
  jQuery('#trending_product .owl-carousel').owlCarousel({
    loop:true,
    margin:10,
    autoplay:true,
    nav:false,
    dots:false,
    smartSpeed:250,
    items: 1,
  })
});

// timer
jQuery(document).ready(function() {
  // Select all product boxes with a timer
  var dateDataSec2 = document.querySelectorAll('.product-box');

  // Iterate over each product box
  dateDataSec2.forEach((element) => {
    // Get the data-date attribute value from the timer element
    var timerElem = jQuery(element).find('.product-timer').attr('data-date');
    if (timerElem !== "") {
      swimwearShopOurEventsTimer(element, timerElem);
    } else {
      jQuery(element).find('.the_timer').html("No timer set.");
    }
  });

  function swimwearShopOurEventsTimer(timerElement, mydate) {
    var countDownDate = new Date(mydate).getTime();
    var x = setInterval(function() {
      var now = new Date().getTime();
      var distance = countDownDate - now;

      // Calculate days, hours, minutes, and seconds
      var days = Math.floor(distance / (1000 * 60 * 60 * 24));
      var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
      var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
      var seconds = Math.floor((distance % (1000 * 60)) / 1000);

      // Format the timer HTML
      var timerHtml = "<div class='timer-box'><span class='numbers'>" + days + "</span><br><span class='nofont'>Days</span></div>" +
                      "<div class='timer-box'><span class='numbers'>" + hours + "</span><br><span class='nofont'>Hours</span></div>" +
                      "<div class='timer-box'><span class='numbers'>" + minutes + "</span><br><span class='nofont'>Min</span></div>" +
                      "<div class='timer-box'><span class='numbers'>" + seconds + "</span><br><span class='nofont'>Secs</span></div>";

      // Get the timer container element
      var timerContainer = jQuery(timerElement).find('.the_timer');

      // Update the timer or clear the interval
      if (timerContainer.length) {
        timerContainer.html(timerHtml);
      } else {
        clearInterval(x);
      }
    }, 1000);
  }
});

