<div class="theme-offer">
   <?php
        // Check if the demo import has been completed
        $swimwear_shop_demo_import_completed = get_option('swimwear_shop_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($swimwear_shop_demo_import_completed) {
            echo '<br>';
            echo '<div class="success">Demo Import Successful</div>';
            echo '<br>';
            echo '<hr>';
            echo '<br>';
            echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'swimwear-shop' ) . '</span>';
            echo '<br>';
            echo '<br>';
            echo '<br>';
            echo '<div class="view-site-btn">';
            echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
            echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
            echo '</div>';
        }
     // POST and update the customizer and other related data of Swimwear Shop
    if ( isset( $_POST['submit'] ) ) {
        echo '<div class="plugin-notice">';
            //Check if WooCommerce is installed and activated
            if (!is_plugin_active('woocommerce/woocommerce.php')) {
                // Install the plugin if it doesn't exist
                $swimwear_shop_plugin_slug = 'woocommerce';
                $swimwear_shop_plugin_file = 'woocommerce/woocommerce.php';

                // Check if plugin is installed
                $swimwear_shop_installed_plugins = get_plugins();
                if (!isset($swimwear_shop_installed_plugins[$swimwear_shop_plugin_file])) {
                    include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                    include_once(ABSPATH . 'wp-admin/includes/file.php');
                    include_once(ABSPATH . 'wp-admin/includes/misc.php');
                    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                    // Install the plugin
                    $swimwear_shop_upgrader = new Plugin_Upgrader();
                    $swimwear_shop_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
                }
                // Activate the plugin
                activate_plugin($swimwear_shop_plugin_file);
            }

            //Check if Sales Countdown Timer is installed and activated
            if (!is_plugin_active('sales-countdown-timer/sales-countdown-timer.php')) {
                // Install the plugin
                include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
                include_once ABSPATH . 'wp-admin/includes/file.php';
                include_once ABSPATH . 'wp-admin/includes/misc.php';
                include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

                $swimwear_shop_plugin_slug = 'sales-countdown-timer';
                $swimwear_shop_api = plugins_api('plugin_information', array('slug' => $swimwear_shop_plugin_slug));

                if (is_wp_error($swimwear_shop_api)) {
                    return;
                }

                $swimwear_shop_upgrader = new Plugin_Upgrader(new Automatic_Upgrader_Skin());
                $swimwear_shop_upgrader->install($swimwear_shop_api->download_link);

                // Activate the plugin
                activate_plugin('sales-countdown-timer/sales-countdown-timer.php');
            }

            // Check if Classic Blog Grid plugin is installed
            if (!is_plugin_active('classic-blog-grid/classic-blog-grid.php')) {
                // Plugin slug and file path for Classic Blog Grid
                $swimwear_shop_plugin_slug = 'classic-blog-grid';
                $swimwear_shop_plugin_file = 'classic-blog-grid/classic-blog-grid.php';
            
                // Check if Classic Blog Grid is installed and activated
                if ( ! is_plugin_active( $swimwear_shop_plugin_file ) ) {
            
                    // Check if Classic Blog Grid is installed
                    $swimwear_shop_installed_plugins = get_plugins();
                    if ( ! isset( $swimwear_shop_installed_plugins[ $swimwear_shop_plugin_file ] ) ) {
            
                        // Include necessary files to install plugins
                        include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
                        include_once( ABSPATH . 'wp-admin/includes/file.php' );
                        include_once( ABSPATH . 'wp-admin/includes/misc.php' );
                        include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
            
                        // Download and install Classic Blog Grid
                        $swimwear_shop_upgrader = new Plugin_Upgrader();
                        $swimwear_shop_upgrader->install( 'https://downloads.wordpress.org/plugin/classic-blog-grid.latest-stable.zip' );
                    }
            
                    // Activate the Classic Blog Grid plugin after installation (if needed)
                    activate_plugin( $swimwear_shop_plugin_file );
                }
            }
        echo '</div>';
        // ------- Create Main Menu --------
        $swimwear_shop_menuname = 'Primary Menu';
        $swimwear_shop_bpmenulocation = 'primary';
        $swimwear_shop_menu_exists = wp_get_nav_menu_object( $swimwear_shop_menuname );
    
        if (!$swimwear_shop_menu_exists) {
            // Create a new menu
            $swimwear_shop_menu_id = wp_create_nav_menu($swimwear_shop_menuname);

            // Define pages to be created
            $swimwear_shop_pages = array(
                'home' => array(
                    'title' => 'Home',
                    'template' => '/templates/template-home-page.php'
                ),
                'blogs' => array(
                    'title' => 'Blogs',
                    'content' => ''
                ),
                'brand' => array(
                    'title' => 'Brand',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'size-shop' => array(
                    'title' => 'Size Shop',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'lingerie' => array(
                    'title' => 'Lingerie',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'swim-suit' => array(
                    'title' => 'Swim Suit',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'pages' => array(
                    'title' => 'Pages',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
            );

            $swimwear_shop_page_ids = array();

            // Loop through the pages and create them if they don’t exist
            foreach ($swimwear_shop_pages as $swimwear_shop_slug => $swimwear_shop_data) {
                $swimwear_shop_existing_page = get_page_by_path($swimwear_shop_slug);

                if ($swimwear_shop_existing_page) {
                    // If the page already exists, use its ID
                    $swimwear_shop_page_id = $swimwear_shop_existing_page->ID;
                } else {
                    // Create a new page
                    $swimwear_shop_page_data = array(
                        'post_type'    => 'page',
                        'post_title'   => $swimwear_shop_data['title'],
                        'post_content' => isset($swimwear_shop_data['content']) ? $swimwear_shop_data['content'] : '',
                        'post_status'  => 'publish',
                        'post_author'  => get_current_user_id(), // Set author dynamically
                        'post_name'    => $swimwear_shop_slug,
                    );

                    $swimwear_shop_page_id = wp_insert_post($swimwear_shop_page_data);

                    // Assign custom page template if specified
                    if (!empty($swimwear_shop_data['template'])) {
                        update_post_meta($swimwear_shop_page_id, '_wp_page_template', $swimwear_shop_data['template']);
                    }
                }

                // Store the page IDs
                $swimwear_shop_page_ids[$swimwear_shop_slug] = $swimwear_shop_page_id;
            }

            // Set homepage and blog page
            update_option('page_for_posts', $swimwear_shop_page_ids['blogs']);
            update_option('page_on_front', $swimwear_shop_page_ids['home']);
            update_option('show_on_front', 'page');

            // Define menu items
            $swimwear_shop_menu_items = array(
                'home',
                'blogs',
                'brand',
                'size-shop',
                'lingerie',
                'swim-suit',
                'pages'
            );

            // Add menu items dynamically
            foreach ($swimwear_shop_menu_items as $swimwear_shop_slug) {
                wp_update_nav_menu_item($swimwear_shop_menu_id, 0, array(
                    'menu-item-title' => esc_html($swimwear_shop_pages[$swimwear_shop_slug]['title']),
                    'menu-item-url' => get_permalink($swimwear_shop_page_ids[$swimwear_shop_slug]),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $swimwear_shop_page_ids[$swimwear_shop_slug],
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type',
                ));
            }

            // Assign menu to theme location
            $swimwear_shop_locations = get_theme_mod('nav_menu_locations', array());
            $swimwear_shop_locations[$swimwear_shop_bpmenulocation] = $swimwear_shop_menu_id;
            set_theme_mod('nav_menu_locations', $swimwear_shop_locations);
        }

        //Logo
        set_theme_mod( 'swimwear_shop_the_custom_logo', esc_url( get_template_directory_uri().'/images/Logo.png'));

        //Slider Section
        set_theme_mod( 'swimwear_shop_slider', true);
        set_theme_mod( 'swimwear_shop_slider_small_title', 'SWIM WEARS SINCE 1983');
        set_theme_mod( 'swimwear_shop_slider_subhead', 'Women\'s Personal Affair');
        set_theme_mod( 'swimwear_shop_button_text', 'View All Collection');
        
        $swimwear_shop_slider_category_id = wp_create_category('Slider');
        // Set the category in theme mods for the slider section
        set_theme_mod('swimwear_shop_slider_cat', 'Slider'); // Update with correct category ID
        
        // Titles for the three posts
        $swimwear_shop_titles = array(
            'Sunny Swimwear',
            'Tropical One-Piece',
            'Bikini Breeze'
        );
       
        // Create three demo posts and assign them to the 'Slider' category
        for ($swimwear_shop_i = 1; $swimwear_shop_i <= 3; $swimwear_shop_i++) {
            $swimwear_shop_title = $swimwear_shop_titles[$swimwear_shop_i - 1];
            $swimwear_shop_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.';
        
            // Prepare the post object
            $swimwear_shop_my_post = array(
                'post_title'    => wp_strip_all_tags($swimwear_shop_title),
                'post_content'  => $swimwear_shop_content,
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => array($swimwear_shop_slider_category_id),
            );
        
            // Insert the post into the database
            $swimwear_shop_post_id = wp_insert_post($swimwear_shop_my_post);
        
            // If the post was successfully created, set the featured image
            if ($swimwear_shop_post_id && !is_wp_error($swimwear_shop_post_id)) {
                // Set the image URL based on the current slider index
                $swimwear_shop_image_url = esc_url(get_stylesheet_directory_uri() . '/images/slider' . $swimwear_shop_i . '.png');
                $swimwear_shop_upload_dir = wp_upload_dir();
        
                // Download the image data using wp_remote_get()
                $swimwear_shop_response = wp_remote_get($swimwear_shop_image_url);
                if (!is_wp_error($swimwear_shop_response)) {
                    $swimwear_shop_image_data = wp_remote_retrieve_body($swimwear_shop_response);
        
                    if (!empty($swimwear_shop_image_data)) {
                        // Handle the file upload process
                        $swimwear_shop_image_name = 'slider' . $swimwear_shop_i . '.png';
                        $swimwear_shop_unique_file_name = wp_unique_filename($swimwear_shop_upload_dir['path'], $swimwear_shop_image_name);
                        $swimwear_shop_file = $swimwear_shop_upload_dir['path'] . '/' . $swimwear_shop_unique_file_name;
        
                        // Save the image file to the uploads directory
                        global $wp_filesystem;
                        WP_Filesystem();
                        $wp_filesystem->put_contents($swimwear_shop_file, $swimwear_shop_image_data);
        
                        // Check file type and prepare for attachment
                        $swimwear_shop_wp_filetype = wp_check_filetype($swimwear_shop_unique_file_name, null);
                        $swimwear_shop_attachment = array(
                            'post_mime_type' => $swimwear_shop_wp_filetype['type'],
                            'post_title'     => sanitize_file_name($swimwear_shop_unique_file_name),
                            'post_content'   => '',
                            'post_status'    => 'inherit',
                        );
        
                        // Insert the image into the media library and set it as the post's featured image
                        $swimwear_shop_attach_id = wp_insert_attachment($swimwear_shop_attachment, $swimwear_shop_file, $swimwear_shop_post_id);
                        $swimwear_shop_attach_data = wp_generate_attachment_metadata($swimwear_shop_attach_id, $swimwear_shop_file);
                        wp_update_attachment_metadata($swimwear_shop_attach_id, $swimwear_shop_attach_data);
                        set_post_thumbnail($swimwear_shop_post_id, $swimwear_shop_attach_id);
                    }
                }
            }
        }

        //Products Section
        set_theme_mod( 'swimwear_shop_product_selling', true);
        set_theme_mod('swimwear_shop_hot_products_cat', 'productcategory1');

        // Define product category names, product titles, and tags
        $swimwear_shop_category_names = array('productcategory1', 'productcategory2', 'productcategory3');
        $swimwear_shop_title_array = array(
            array("Golden Rays Of Sunshine Beach Swimwear", "Tropical Breeze Floral Bikini", "Ocean Blue Classic Swim Trunks"),
            array("Golden Rays Of Sunshine Beach Swimwear", "Tropical Breeze Floral Bikini", "Ocean Blue Classic Swim Trunks"),
            array("Golden Rays Of Sunshine Beach Swimwear", "Tropical Breeze Floral Bikini", "Ocean Blue Classic Swim Trunks")
        );

        foreach ($swimwear_shop_category_names as $swimwear_shop_index => $swimwear_shop_category_name) {
            // Create or retrieve the product category term ID
            $swimwear_shop_term = term_exists($swimwear_shop_category_name, 'product_cat');
            
            // If the term doesn't exist, create it
            if ($swimwear_shop_term === 0 || $swimwear_shop_term === null) {
                $swimwear_shop_term = wp_insert_term($swimwear_shop_category_name, 'product_cat');
            }
            
            // Check for errors in category creation
            if (is_wp_error($swimwear_shop_term)) {
                error_log('Error creating category: ' . $swimwear_shop_term->get_error_message());
                continue; // Skip to the next iteration if category creation fails
            }

            // Retrieve the category ID for assignment
            $swimwear_shop_term_id = $swimwear_shop_term['term_id'];

            // Loop to create 4 products for each category
            for ($swimwear_shop_i = 0; $swimwear_shop_i < 3; $swimwear_shop_i++) {
                // Create product content
                $swimwear_shop_title = $swimwear_shop_title_array[$swimwear_shop_index][$swimwear_shop_i];
                $swimwear_shop_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.';

                // Create product post object
                $swimwear_shop_my_post = array(
                    'post_title'    => wp_strip_all_tags($swimwear_shop_title),
                    'post_content'  => $swimwear_shop_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'product', // Post type set to 'product'
                );

                // Insert the product into the database
                $swimwear_shop_post_id = wp_insert_post($swimwear_shop_my_post);

                // Check for errors in product creation
                if (is_wp_error($swimwear_shop_post_id)) {
                    error_log('Error creating product: ' . $swimwear_shop_post_id->get_error_message());
                    continue; // Skip to the next product if creation fails
                }

                // Assign the category to the product
                wp_set_object_terms($swimwear_shop_post_id, array($swimwear_shop_term_id), 'product_cat');
                
                // Set product as simple product and assign price
                update_post_meta($swimwear_shop_post_id, '_regular_price', 90.00); // Assign regular price
                update_post_meta($swimwear_shop_post_id, '_sale_price', 70.00); // Assign sale price
                update_post_meta($swimwear_shop_post_id, '_sale_price_dates_from', strtotime('2024-05-24')); // Sale start date
                update_post_meta($swimwear_shop_post_id, '_sale_price_dates_to', strtotime('2027-12-12')); // Sale end date
                update_post_meta($swimwear_shop_post_id, '_price', 70.00); // Set current price (sale price)

                // Handle the featured image using media_sideload_image
                $swimwear_shop_image_url = get_template_directory_uri() . '/images/product' . ($swimwear_shop_i + 1) . '.png';
                $swimwear_shop_image_id = media_sideload_image($swimwear_shop_image_url, $swimwear_shop_post_id, null, 'id');

                // Check if there was an error downloading the image
                if (is_wp_error($swimwear_shop_image_id)) {
                    error_log('Error downloading image: ' . $swimwear_shop_image_id->get_error_message());
                    continue; // Skip to the next product if image download fails
                }

                // Assign featured image to product
                set_post_thumbnail($swimwear_shop_post_id, $swimwear_shop_image_id);
            }
        }

        // Show success message and the "View Site" button
        update_option('swimwear_shop_demo_import_completed', true);
        echo '<br>';
        echo '<div class="success">Demo Import Successful</div>';
        echo '<br>';
        echo '<hr>';
        echo '<br>';
        echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'swimwear-shop' ) . '</span>';
        echo '<br>';
    }
     ?>
    <ul>
        <li>
        <?php 
        // Check if the form is submitted
        if ( !isset( $_POST['submit'] ) ) : ?>
            <!-- Show demo importer form only if it's not submitted -->
            <?php if (!get_option('swimwear_shop_demo_import_completed')) : ?>
                <span><?php echo esc_html( 'Click on the below content to get demo content installed.', 'swimwear-shop' ); ?></span>
                <br><br>
                <hr><br>
                <b class="note"><?php echo esc_html('Note :', 'swimwear-shop' ); ?></b><br><br>
                <small><b><?php echo esc_html('Please take a backup if your website is already live with data. This importer will overwrite existing data.', 'swimwear-shop' ); ?></b></small><br><br>
                <form id="demo-importer-form" action="" method="POST" onsubmit="return runDemoImport();">
                    <input type="submit" name="submit" value="<?php echo esc_attr('Run Importer','swimwear-shop'); ?>" class="button button-primary button-large">
                </form>
                <script type="text/javascript">
                    function runDemoImport() {
                        if (confirm('Do you really want to do this?')) {
                            document.getElementById('demo-import-loader').style.display = 'block';
                            return true;
                        }
                        return false;
                    }
                </script>
             <?php endif; ?>
         <?php 
        endif; 

        // Show "View Site" button after form submission
        if ( isset( $_POST['submit'] ) ) {
        echo '<div class="view-site-btn">';
        echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
        echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
        echo '</div>';
        }
        ?>
        </li>
    </ul>
 </div>