<?php
/**
 * Swimwear Shop Theme Customizer
 *
 * @package Swimwear Shop
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function swimwear_shop_customize_register( $wp_customize ) {

	function swimwear_shop_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('swimwear-shop-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	// Enable / Disable Logo
	$wp_customize->add_setting('swimwear_shop_logo_enable',array(
		'default' => true,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_logo_enable', array(
		'settings' => 'swimwear_shop_logo_enable',
		'section'   => 'title_tagline',
		'label'     => __('Enable Logo','swimwear-shop'),
		'type'      => 'checkbox'
	));

	//Logo
    $wp_customize->add_setting('swimwear_shop_logo_width',array(
		'default'=> '',
		'transport' => 'refresh',
		'sanitize_callback' => 'swimwear_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Swimwear_Shop_Slider_Custom_Control( $wp_customize, 'swimwear_shop_logo_width',array(
		'label'	=> esc_html__('Logo Width','swimwear-shop'),
		'section'=> 'title_tagline',
		'settings'=>'swimwear_shop_logo_width',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 300,
        ),
	)));

	// color site title
	$wp_customize->add_setting('swimwear_shop_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_sitetitle_color', array(
	   'settings' => 'swimwear_shop_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('swimwear_shop_title_enable',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_title_enable', array(
	   'settings' => 'swimwear_shop_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','swimwear-shop'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('swimwear_shop_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_sitetagline_color', array(
	   'settings' => 'swimwear_shop_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('swimwear_shop_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_tagline_enable', array(
	   'settings' => 'swimwear_shop_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','swimwear-shop'),
	   'type'      => 'checkbox'
	));

	$wp_customize->add_setting( 'swimwear_shop_logo_upgraded_features',array(
    'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_logo_upgraded_features', array(
	    'type'=> 'hidden',
	    'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
	        <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
	    'section' => 'title_tagline'
	));

	// woocommerce section
	$wp_customize->add_section('swimwear_shop_woocommerce_page_settings', array(
		'title'    => __('WooCommerce Page Settings', 'swimwear-shop'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting('swimwear_shop_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_shop_page_sidebar',array(
		'type' => 'checkbox',
		'label' => __(' Check To Enable Shop page sidebar','swimwear-shop'),
		'section' => 'swimwear_shop_woocommerce_page_settings',
	));

    // shop page sidebar alignment
    $wp_customize->add_setting('swimwear_shop_shop_page_sidebar_position', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices',
	));
	$wp_customize->add_control('swimwear_shop_shop_page_sidebar_position',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Sidebar', 'swimwear-shop'),
		'section'        => 'swimwear_shop_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'swimwear-shop'),
			'Right Sidebar' => __('Right Sidebar', 'swimwear-shop'),
		),
	));	 

	$wp_customize->add_setting('swimwear_shop_wooproducts_nav',array(
		'default' => 'Yes',
		'sanitize_callback'	=> 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_wooproducts_nav',array(
		'type' => 'select',
		'label' => __('Shop Page Products Navigation','swimwear-shop'),
		'choices' => array(
			 'Yes' => __('Yes','swimwear-shop'),
			 'No' => __('No','swimwear-shop'),
		 ),
		'section' => 'swimwear_shop_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'swimwear_shop_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
    ) );
    $wp_customize->add_control('swimwear_shop_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Check To Enable Single Product Page Sidebar','swimwear-shop'),
		'section' => 'swimwear_shop_woocommerce_page_settings'
    ));

	// single product page sidebar alignment
    $wp_customize->add_setting('swimwear_shop_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices',
	));
	$wp_customize->add_control('swimwear_shop_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page Sidebar', 'swimwear-shop'),
		'section'        => 'swimwear_shop_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'swimwear-shop'),
			'Right Sidebar' => __('Right Sidebar', 'swimwear-shop'),
		),
	));	

	$wp_customize->add_setting('swimwear_shop_related_product_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_related_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Check To Enable Related product','swimwear-shop'),
		'section' => 'swimwear_shop_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'swimwear_shop_woo_product_img_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'swimwear_shop_sanitize_integer'
    ) );
    $wp_customize->add_control(new Swimwear_Shop_Slider_Custom_Control( $wp_customize, 'swimwear_shop_woo_product_img_border_radius',array(
		'label'	=> esc_html__('Product Img Border Radius','swimwear-shop'),
		'section'=> 'swimwear_shop_woocommerce_page_settings',
		'settings'=>'swimwear_shop_woo_product_img_border_radius',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	// Add a setting for number of products per row
	$wp_customize->add_setting('swimwear_shop_products_per_row', array(
		'default'   => '4',
		'transport' => 'refresh',
		'sanitize_callback' => 'swimwear_shop_sanitize_integer'
	));
	$wp_customize->add_control('swimwear_shop_products_per_row', array(
		'label'    => __('Products Per Row', 'swimwear-shop'),
		'section'  => 'swimwear_shop_woocommerce_page_settings',
		'settings' => 'swimwear_shop_products_per_row',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
		),
	));

	// Add a setting for the number of products per page
	$wp_customize->add_setting('swimwear_shop_products_per_page', array(
		'default'   => '9',
		'transport' => 'refresh',
		'sanitize_callback' => 'swimwear_shop_sanitize_integer'
	));
	$wp_customize->add_control('swimwear_shop_products_per_page', array(
		'label'    => __('Products Per Page', 'swimwear-shop'),
		'section'  => 'swimwear_shop_woocommerce_page_settings',
		'settings' => 'swimwear_shop_products_per_page',
		'type'     => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'step' => 1,
		),
	));

	$wp_customize->add_setting('swimwear_shop_product_sale_position',array(
		'default' => 'Left',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_product_sale_position',array(
			'type' => 'radio',
			'label' => __('Product Sale Position','swimwear-shop'),
			'section' => 'swimwear_shop_woocommerce_page_settings',
			'choices' => array(
				'Left' => __('Left','swimwear-shop'),
				'Right' => __('Right','swimwear-shop'),
			),
	));    

	//Theme Options
	$wp_customize->add_panel( 'swimwear_shop_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'swimwear-shop' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('swimwear_shop_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','swimwear-shop'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','swimwear-shop'),
		'priority'	=> 1,
		'panel' => 'swimwear_shop_panel_area',
	));

	$wp_customize->add_setting('swimwear_shop_preloader',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_preloader', array(
	   'section'   => 'swimwear_shop_site_layoutsec',
	   'label'	=> __('Check to Show preloader','swimwear-shop'),
	   'type'      => 'checkbox'
 	));	

	$wp_customize->add_setting('swimwear_shop_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_box_layout', array(
	   'section'   => 'swimwear_shop_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','swimwear-shop'),
	   'type'      => 'checkbox'
 	));

   // Add Settings and Controls for Page Layout
    $wp_customize->add_setting('swimwear_shop_sidebar_page_layout',array(
		'default' => 'full',
	 	'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'swimwear-shop'),
		'section' => 'swimwear_shop_site_layoutsec',
		'choices' => array(
			'left' => __('Left','swimwear-shop'),
			'right' => __('Right','swimwear-shop'),
			'full' => __('No Sidebar','swimwear-shop')
	),
	) );	

 	$wp_customize->add_setting( 'swimwear_shop_site_upgraded_features',array(
   		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_site_upgraded_features', array(
	    'type'=> 'hidden',
	    'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
	        <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
	    'section' => 'swimwear_shop_site_layoutsec'
	));

    //Global Color
	$wp_customize->add_section('swimwear_shop_global_color', array(
		'title'    => __('Manage Global Color Section', 'swimwear-shop'),
		'panel'    => 'swimwear_shop_panel_area',
	));

	$wp_customize->add_setting('swimwear_shop_first_color', array(
		'default'           => '#03b0c1',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'swimwear_shop_first_color', array(
		'label'    => __('Theme Color', 'swimwear-shop'),
		'section'  => 'swimwear_shop_global_color',
		'settings' => 'swimwear_shop_first_color',
	)));	

	$wp_customize->add_setting( 'swimwear_shop_global_color_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_global_color_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_global_color'
	));	   

 	// Header Section
	$wp_customize->add_section('swimwear_shop_header_section', array(
        'title' => __('Manage Header Section', 'swimwear-shop'),
		'description' => __('<p class="sec-title">Manage Header Section</p>','swimwear-shop'),
        'priority' => null,
		'panel' => 'swimwear_shop_panel_area',
 	));

	// Sticky Header
	$wp_customize->add_setting( 'swimwear_shop_sticky_header',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_sticky_header',array(
		'settings' => 'swimwear_shop_sticky_header',
		'section'   => 'swimwear_shop_header_section',
		'label' => esc_html__( 'Check To Enable Sticky Header','swimwear-shop' ),
		'type'      => 'checkbox'
	));	

 	$wp_customize->add_setting('swimwear_shop_header_currency_switcher',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control( 'swimwear_shop_header_currency_switcher', array(
	   'section'   => 'swimwear_shop_header_section',
	   'label'	=> __('Check to Show Curreny Switcher','swimwear-shop'),
	   'type'      => 'checkbox'
 	));

	// header menu
	$wp_customize->add_setting('swimwear_shop_menu_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_menu_color', array(
	   'settings' => 'swimwear_shop_menu_color',
	   'section'   => 'swimwear_shop_header_section',
	   'label' => __('Menu Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	// header menu hover color
	$wp_customize->add_setting('swimwear_shop_menuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_menuhrv_color', array(
	   'settings' => 'swimwear_shop_menuhrv_color',
	   'section'   => 'swimwear_shop_header_section',
	   'label' => __('Menu Hover Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	// header sub menu color
	$wp_customize->add_setting('swimwear_shop_submenu_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_submenu_color', array(
	   'settings' => 'swimwear_shop_submenu_color',
	   'section'   => 'swimwear_shop_header_section',
	   'label' => __('SubMenu Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	// header sub menu hover color
	$wp_customize->add_setting('swimwear_shop_submenuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_submenuhrv_color', array(
	   'settings' => 'swimwear_shop_submenuhrv_color',
	   'section'   => 'swimwear_shop_header_section',
	   'label' => __('SubMenu Hover Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

    // Menu Text Transform
    $wp_customize->add_setting( 'swimwear_shop_menu_text_transform', array(
        'default'           => 'Capitalize',
		'transport' => 'refresh',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices'
    ));

    $wp_customize->add_control( 'swimwear_shop_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'swimwear-shop' ),
        'section'  => 'swimwear_shop_header_section',
        'type'     => 'select',
        'choices'  => array(
			'None'       => __( 'None', 'swimwear-shop' ),
            'Capitalize' => __( 'Capitalize', 'swimwear-shop' ),
            'Uppercase'  => __( 'Uppercase', 'swimwear-shop' ),
            'Lowercase'  => __( 'Lowercase', 'swimwear-shop' ),
        ),
    ));

	$wp_customize->add_setting( 'swimwear_shop_header_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_header_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_header_section'
	));

	//Slider
  	$wp_customize->add_section('swimwear_shop_slider_section',array(
	    'title' => __('Manage Slider Section','swimwear-shop'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Slider Section</p> Select Category from the Dropdowns for slider, Also use the given image dimension (450 x 380).','swimwear-shop'),
	    'panel' => 'swimwear_shop_panel_area',
	));

	$wp_customize->add_setting('swimwear_shop_slider',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_slider', array(
	   'settings' => 'swimwear_shop_slider',
	   'section'   => 'swimwear_shop_slider_section',
	   'label'     => __('Check To Enable This Section','swimwear-shop'),
	   'type'      => 'checkbox'
	));

	$wp_customize->add_setting('swimwear_shop_slider_small_title',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_slider_small_title', array(
	   'settings' => 'swimwear_shop_slider_small_title',
	   'section'   => 'swimwear_shop_slider_section',
	   'label' => __('Add Slider Small Title', 'swimwear-shop'),
	   'type'      => 'text'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

    $wp_customize->add_setting('swimwear_shop_slider_cat',array(
	    'default' => '0',
	    'sanitize_callback' => 'swimwear_shop_sanitize_choices',
  	));
  	$wp_customize->add_control('swimwear_shop_slider_cat',array(
	    'type'    => 'select',
	    'choices' => $cat_post,
	    'label' => __('Select Category to display Latest Post','swimwear-shop'),
	    'section' => 'swimwear_shop_slider_section',
	));

	$wp_customize->add_setting('swimwear_shop_slider_subhead',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_slider_subhead', array(
	   'settings' => 'swimwear_shop_slider_subhead',
	   'section'   => 'swimwear_shop_slider_section',
	   'label' => __('Add Slider Subheading', 'swimwear-shop'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('swimwear_shop_button_text',array(
		'default' => 'View All Collection',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_button_text', array(
	   'settings' => 'swimwear_shop_button_text',
	   'section'   => 'swimwear_shop_slider_section',
	   'label' => __('Add Slider Button Text', 'swimwear-shop'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('swimwear_shop_button_link_slider',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('swimwear_shop_button_link_slider',array(
        'label' => esc_html__('Add Slider Button Link','swimwear-shop'),
        'section'=> 'swimwear_shop_slider_section',
        'type'=> 'url'
    ));

	$wp_customize->add_setting( 'swimwear_shop_slider_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_slider_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_slider_section'
	));

	//  Products Category Section
	$wp_customize->add_section('swimwear_shop_two_cols_section',array(
		'title'	=> __('Manage Products Section','swimwear-shop'),
		'description' => __('<p class="sec-title">Manage Products Section</p>','swimwear-shop'),
		'priority'	=> null,
		'panel' => 'swimwear_shop_panel_area'
	));

	//Hide Section
	$wp_customize->add_setting('swimwear_shop_product_selling',array(
		'default' => false,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_product_selling', array(
	   'settings' => 'swimwear_shop_product_selling',
	   'section'   => 'swimwear_shop_two_cols_section',
	   'label'     => __('Check To Enable This Section','swimwear-shop'),
	   'type'      => 'checkbox'
	));
	
	$args = array(
       	'type'                     => 'product',
        'child_of'                 => 0,
        'parent'                   => '',
        'orderby'                  => 'term_group',
        'order'                    => 'ASC',
        'hide_empty'               => false,
        'hierarchical'             => 1,
        'number'                   => '',
        'taxonomy'                 => 'product_cat',
        'pad_counts'               => false
    );
	$categories = get_categories($args);
	$cat_posts = array();
	$m = 0;
	$cat_posts[]='Select';
	foreach($categories as $category){
		if($m==0){
			$default = $category->slug;
			$m++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('swimwear_shop_hot_products_cat',array(
		'default'	=> 'select',
		'sanitize_callback' => 'swimwear_shop_sanitize_select',
	));
	$wp_customize->add_control('swimwear_shop_hot_products_cat',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select category to display products ','swimwear-shop'),
		'section' => 'swimwear_shop_two_cols_section',
	));

	$wp_customize->add_setting( 'swimwear_shop_product_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_product_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_two_cols_section'
	));

	//Blog post
	$wp_customize->add_section('swimwear_shop_blog_post_settings',array(
        'title' => __('Manage Post Section', 'swimwear-shop'),
        'priority' => null,
        'panel' => 'swimwear_shop_panel_area'
    ) );

	$wp_customize->add_setting('swimwear_shop_metafields_date', array(
	    'default' => true,
	    'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control('swimwear_shop_metafields_date', array(
	    'settings' => 'swimwear_shop_metafields_date', 
	    'section'   => 'swimwear_shop_blog_post_settings',
	    'label'     => __('Check to Enable Date', 'swimwear-shop'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('swimwear_shop_metafields_comments', array(
		'default' => true,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control('swimwear_shop_metafields_comments', array(
		'settings' => 'swimwear_shop_metafields_comments',
		'section'  => 'swimwear_shop_blog_post_settings',
		'label'    => __('Check to Enable Comments', 'swimwear-shop'),
		'type'     => 'checkbox',
	));

	$wp_customize->add_setting('swimwear_shop_metafields_author', array(
		'default' => true,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control('swimwear_shop_metafields_author', array(
		'settings' => 'swimwear_shop_metafields_author',
		'section'  => 'swimwear_shop_blog_post_settings',
		'label'    => __('Check to Enable Author', 'swimwear-shop'),
		'type'     => 'checkbox',
	));		

	$wp_customize->add_setting('swimwear_shop_metafields_time', array(
		'default' => true,
		'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control('swimwear_shop_metafields_time', array(
		'settings' => 'swimwear_shop_metafields_time',
		'section'  => 'swimwear_shop_blog_post_settings',
		'label'    => __('Check to Enable Time', 'swimwear-shop'),
		'type'     => 'checkbox',
	));	

	$wp_customize->add_setting('swimwear_shop_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','swimwear-shop'),
		'description' => __('Ex: "/", "|", "-", ...','swimwear-shop'),
		'section' => 'swimwear_shop_blog_post_settings'
	)); 

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('swimwear_shop_sidebar_post_layout',array(
		'default' => 'right',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_sidebar_post_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Post Sidebar Position', 'swimwear-shop'),
		'description'   => __('This option work for blog page, archive page and search page.', 'swimwear-shop'),
		'section' => 'swimwear_shop_blog_post_settings',
		'choices' => array(
			'left' => __('Left','swimwear-shop'),
			'right' => __('Right','swimwear-shop'),
			'three-column' => __('Three Columns','swimwear-shop'),
			'four-column' => __('Four Columns','swimwear-shop'),
			'grid' => __('Grid Layout','swimwear-shop'),
			'full' => __('No Sidebar','swimwear-shop')
     ),
	));

	$wp_customize->add_setting('swimwear_shop_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','swimwear-shop'),
        'section' => 'swimwear_shop_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','swimwear-shop'),
            'Excerpt Content' => __('Excerpt Content','swimwear-shop'),
            'Full Content' => __('Full Content','swimwear-shop'),
        ),
	) );

	$wp_customize->add_setting('swimwear_shop_blog_post_thumb',array(
        'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('swimwear_shop_blog_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Show / Hide Blog Post Thumbnail', 'swimwear-shop'),
        'section'     => 'swimwear_shop_blog_post_settings',
    ));

	$wp_customize->add_setting( 'swimwear_shop_blog_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_blog_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_blog_post_settings'
	));

	//Single Post Settings
	$wp_customize->add_section('swimwear_shop_single_post_settings',array(
		'title' => __('Manage Single Post Section', 'swimwear-shop'),
		'priority' => null,
		'panel' => 'swimwear_shop_panel_area'
	));

	$wp_customize->add_setting('swimwear_shop_single_post_date',array(
		'default' => true,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_single_post_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','swimwear-shop'),
		'section' => 'swimwear_shop_single_post_settings'
	));	

	$wp_customize->add_setting('swimwear_shop_single_post_author',array(
		'default' => true,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_single_post_author',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Author','swimwear-shop'),
		'section' => 'swimwear_shop_single_post_settings'
	));

	$wp_customize->add_setting('swimwear_shop_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','swimwear-shop'),
		'section' => 'swimwear_shop_single_post_settings'
	));	

	$wp_customize->add_setting('swimwear_shop_single_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'swimwear_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('swimwear_shop_single_post_time',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Time','swimwear-shop'),
		'section' => 'swimwear_shop_single_post_settings'
	));	

	$wp_customize->add_setting('swimwear_shop_single_post_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_single_post_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','swimwear-shop'),
		'description' => __('Ex: "/", "|", "-", ...','swimwear-shop'),
		'section' => 'swimwear_shop_single_post_settings'
	)); 

	$wp_customize->add_setting('swimwear_shop_sidebar_single_post_layout',array(
    	'default' => 'right',
    	 'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_sidebar_single_post_layout',array(
   		'type' => 'radio',
    	'label'     => __('Single post sidebar layout', 'swimwear-shop'),
     	'section' => 'swimwear_shop_single_post_settings',
     	'choices' => array(
			'full' => __('Full','swimwear-shop'),
			'left' => __('Left','swimwear-shop'),
			'right' => __('Right','swimwear-shop'),
     ),
	));

	$wp_customize->add_setting( 'swimwear_shop_single_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_single_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_single_post_settings'
	)); 

	//Page Settings
	$wp_customize->add_section('swimwear_shop_page_settings',array(
		'title' => __('Manage Page Section', 'swimwear-shop'),
		'priority' => null,
		'panel' => 'swimwear_shop_panel_area'
	));

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('swimwear_shop_sidebar_page_layout',array(
		'default' => 'full',
			'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'swimwear-shop'),
		'section' => 'swimwear_shop_page_settings',
		'choices' => array(
			'left' => __('Left','swimwear-shop'),
			'right' => __('Right','swimwear-shop'),
			'full' => __('No Sidebar','swimwear-shop')
		),
	));	

	//Page Settings
	$wp_customize->add_section('swimwear_shop_page_settings',array(
		'title' => __('Manage Page Section', 'swimwear-shop'),
		'priority' => null,
		'panel' => 'swimwear_shop_panel_area'
	));

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('swimwear_shop_sidebar_page_layout',array(
		'default' => 'full',
			'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'swimwear-shop'),
		'section' => 'swimwear_shop_page_settings',
		'choices' => array(
			'left' => __('Left','swimwear-shop'),
			'right' => __('Right','swimwear-shop'),
			'full' => __('No Sidebar','swimwear-shop')
		),
	));	

	// 404 Page Settings
	$wp_customize->add_section('swimwear_shop_page_not_found', array(
		'title'	=> __('Manage 404 Page Section','swimwear-shop'),
		'priority'	=> null,
		'panel' => 'swimwear_shop_panel_area',
	));
	
	$wp_customize->add_setting('swimwear_shop_page_not_found_heading',array(
		'default'=> __('404 Not Found','swimwear-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_page_not_found_heading',array(
		'label'	=> __('404 Heading','swimwear-shop'),
		'section'=> 'swimwear_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('swimwear_shop_page_not_found_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('swimwear_shop_page_not_found_content',array(
		'label'	=> __('404 Text','swimwear-shop'),
		'input_attrs' => array(
			'placeholder' => __( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'swimwear-shop' ),
		),
		'section'=> 'swimwear_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('swimwear_shop_page_not_found_btn',array(
		'default' => 'Homepage',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_page_not_found_btn', array(
	   'settings' => 'swimwear_shop_page_not_found_btn',
	   'section'   => 'swimwear_shop_page_not_found',
	   'label' => __('404 Button', 'swimwear-shop'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting( 'swimwear_shop_page_not_found_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_page_not_found_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_page_not_found'
	));

	// Footer Section
	$wp_customize->add_section('swimwear_shop_footer', array(
		'title'	=> __('Manage Footer Section','swimwear-shop'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','swimwear-shop'),
		'priority'	=> null,
		'panel' => 'swimwear_shop_panel_area',
	));

	$wp_customize->add_setting('swimwear_shop_footer_widget', array(
	    'default' => true,
	    'sanitize_callback' => 'swimwear_shop_sanitize_checkbox',
	));
	$wp_customize->add_control('swimwear_shop_footer_widget', array(
	    'settings' => 'swimwear_shop_footer_widget', // Corrected setting name
	    'section'   => 'swimwear_shop_footer',
	    'label'     => __('Check to Enable Footer Widget', 'swimwear-shop'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('swimwear_shop_copyright_line',array(
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'swimwear_shop_copyright_line', array(
	   'section' 	=> 'swimwear_shop_footer',
	   'label'	 	=> __('Copyright Line','swimwear-shop'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	$wp_customize->add_setting('swimwear_shop_copyright_link',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));	
	$wp_customize->add_control( 'swimwear_shop_copyright_link', array(
	   'section' 	=> 'swimwear_shop_footer',
	   'label'	 	=> __('Copyright Link','swimwear-shop'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer bg color
	$wp_customize->add_setting('swimwear_shop_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footerbg_color', array(
	   'settings' => 'swimwear_shop_footerbg_color',
	   'section'   => 'swimwear_shop_footer',
	   'label' => __('Footer Background Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('swimwear_shop_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'swimwear_shop_footer_bg_image',array(
        'label' => __('Footer Background Image','swimwear-shop'),
        'section' => 'swimwear_shop_footer',
    )));

	$wp_customize->add_setting('swimwear_shop_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'swimwear_shop_sanitize_choices'
	));
	$wp_customize->add_control('swimwear_shop_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','swimwear-shop'),
		'section' => 'swimwear_shop_footer',
		'choices' 	=> array(
			'center center'   => esc_html__( 'Center', 'swimwear-shop' ),
			'center top'   => esc_html__( 'Top', 'swimwear-shop' ),
			'left center'   => esc_html__( 'Left', 'swimwear-shop' ),
			'right center'   => esc_html__( 'Right', 'swimwear-shop' ),
			'center bottom'   => esc_html__( 'Bottom', 'swimwear-shop' ),
		),
	));	

	//  footer title color
	$wp_customize->add_setting('swimwear_shop_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footertitle_color', array(
	   'settings' => 'swimwear_shop_footertitle_color',
	   'section'   => 'swimwear_shop_footer',
	   'label' => __('Title Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('swimwear_shop_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'swimwear_shop_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footerlist_color', array(
	   'settings' => 'swimwear_shop_footerlist_color',
	   'section'   => 'swimwear_shop_footer',
	   'label' => __('List Color', 'swimwear-shop'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('swimwear_shop_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'swimwear_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'swimwear_shop_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'swimwear-shop' ),
        'section'        => 'swimwear_shop_footer',
        'settings'       => 'swimwear_shop_scroll_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('swimwear_shop_scroll_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'swimwear_shop_sanitize_choices'
    ));
    $wp_customize->add_control('swimwear_shop_scroll_position',array(
        'type' => 'radio',
        'section' => 'swimwear_shop_footer',
        'label'	 	=> __('Scroll To Top Positions','swimwear-shop'),
        'choices' => array(
            'Right' => __('Right','swimwear-shop'),
            'Left' => __('Left','swimwear-shop'),
            'Center' => __('Center','swimwear-shop')
        ),
    ));	

	$wp_customize->add_setting('swimwear_shop_scroll_text',array(
		'default'	=> __('TOP','swimwear-shop'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('swimwear_shop_scroll_text',array(
		'label'	=> __('Scroll To Top Button Text','swimwear-shop'),
		'section'	=> 'swimwear_shop_footer',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'swimwear_shop_scroll_top_shape', array(
		'default'           => 'circle',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'swimwear_shop_scroll_top_shape', array(
		'label'    => __( 'Scroll to Top Button Shape', 'swimwear-shop' ),
		'section'  => 'swimwear_shop_footer',
		'settings' => 'swimwear_shop_scroll_top_shape',
		'type'     => 'radio',
		'choices'  => array(
			'box'        => __( 'Box', 'swimwear-shop' ),
			'curved' => __( 'Curved', 'swimwear-shop'),
			'circle'     => __( 'Circle', 'swimwear-shop' ),
		),
	));

	$wp_customize->add_setting('swimwear_shop_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'swimwear_shop_sanitize_choices',
	));
	$wp_customize->add_control('swimwear_shop_footer_widget_areas',array(
		'type'        => 'radio',
		'section' => 'swimwear_shop_footer',
		'label'       => __('Footer widget area', 'swimwear-shop'),
		'choices' => array(
		   '1'     => __('One', 'swimwear-shop'),
		   '2'     => __('Two', 'swimwear-shop'),
		   '3'     => __('Three', 'swimwear-shop'),
		   '4'     => __('Four', 'swimwear-shop')
		),
	));

	$wp_customize->add_setting( 'swimwear_shop_footer_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_footer_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_footer'
	));

	// Footer Social Section
	$wp_customize->add_section('swimwear_shop_footer_social_icons', array(
		'title'	=> __('Manage Footer Social Section','swimwear-shop'),
		'description'	=> __('<p class="sec-title">Manage Footer Social Section</p>','swimwear-shop'),
		'priority'	=> null,
		'panel' => 'swimwear_shop_panel_area',
	));

	$wp_customize->add_setting('swimwear_shop_footer_facebook_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footer_facebook_link', array(
		'settings' => 'swimwear_shop_footer_facebook_link',
		'section'   => 'swimwear_shop_footer_social_icons',
		'label' => __('Facebook Link', 'swimwear-shop'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('swimwear_shop_footer_instagram_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footer_instagram_link', array(
		'settings' => 'swimwear_shop_footer_instagram_link',
		'section'   => 'swimwear_shop_footer_social_icons',
		'label' => __('Instagram Link', 'swimwear-shop'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('swimwear_shop_footer_pinterest_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footer_pinterest_link', array(
		'settings' => 'swimwear_shop_footer_pinterest_link',
		'section'   => 'swimwear_shop_footer_social_icons',
		'label' => __('Pinterest Link', 'swimwear-shop'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('swimwear_shop_footer_twitter_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footer_twitter_link', array(
		'settings' => 'swimwear_shop_footer_twitter_link',
		'section'   => 'swimwear_shop_footer_social_icons',
		'label' => __('Twitter Link', 'swimwear-shop'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('swimwear_shop_footer_youtube_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'swimwear_shop_footer_youtube_link', array(
		'settings' => 'swimwear_shop_footer_youtube_link',
		'section'   => 'swimwear_shop_footer_social_icons',
		'label' => __('Youtube Link', 'swimwear-shop'),
		'type'      => 'url'
	));

	$wp_customize->add_setting( 'swimwear_shop_footer_social_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('swimwear_shop_footer_social_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme') ." '>Upgrade to Pro</a></span>",
		'section' => 'swimwear_shop_footer_social_icons'
	));

	// Google Fonts
	$wp_customize->add_section( 'swimwear_shop_google_fonts_section', array(
		'title'       => __( 'Google Fonts', 'swimwear-shop' ),
		'priority'    => 24,
	) );

	$font_choices = array(
		'' => 'No Fonts',
		'Kaushan Script:' => 'Kaushan Script',
		'Emilys Candy:' => 'Emilys Candy',
		'Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900' => 'Poppins',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);

	$wp_customize->add_setting( 'swimwear_shop_headings_fonts', array(
		'sanitize_callback' => 'swimwear_shop_sanitize_fonts',
	));
	$wp_customize->add_control( 'swimwear_shop_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the headings.', 'swimwear-shop'),
		'section' => 'swimwear_shop_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'swimwear_shop_body_fonts', array(
		'sanitize_callback' => 'swimwear_shop_sanitize_fonts'
	));
	$wp_customize->add_control( 'swimwear_shop_body_fonts', array(
		'type' => 'select',
		'description' => __( 'Select your desired font for the body.', 'swimwear-shop' ),
		'section' => 'swimwear_shop_google_fonts_section',
		'choices' => $font_choices
	));	

}
add_action( 'customize_register', 'swimwear_shop_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function swimwear_shop_customize_preview_js() {
	wp_enqueue_script( 'swimwear_shop_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'swimwear_shop_customize_preview_js' );
