<?php
/**
 * @package Swimwear Shop
 * Setup the WordPress core custom header feature.
 *
 * @uses swimwear_shop_header_style()
 */
function swimwear_shop_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'swimwear_shop_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 2500,
		'height'                 => 400,
		'wp-head-callback'       => 'swimwear_shop_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'swimwear_shop_custom_header_setup' );

if ( ! function_exists( 'swimwear_shop_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see swimwear_shop_custom_header_setup().
 */
function swimwear_shop_header_style() {
	$swimwear_shop_header_text_color = get_header_textcolor();

	?>
	<style type="text/css">
	<?php
		//Check if user has defined any header image.
		if ( get_header_image() || get_header_textcolor() ) :
	?>
		.header {
			background: url(<?php echo esc_url( get_header_image() ); ?>) no-repeat !important;
			background-position: center top;
			background-size: cover !important;
		}

	<?php endif; ?>	

	h1.site-title a, p.site-title a{
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_sitetitle_color')); ?> !important;
	}

	.site-description{
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_sitetagline_color')); ?> !important;
	}

	.main-nav ul li a {
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_menu_color')); ?> !important;
	}

	.main-nav a:hover{
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_menuhrv_color')); ?> !important;
	}

	.main-nav ul ul a{
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_submenu_color')); ?> !important;
	}

	.main-nav ul ul a:hover {
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_submenuhrv_color')); ?> !important;
	}

	#footer h3  {
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_footertitle_color')); ?> !important;

	}
	#footer ul li a {
		color: <?php echo esc_attr(get_theme_mod('swimwear_shop_footerlist_color')); ?>;

	}
	#footer {
		background-color: <?php echo esc_attr(get_theme_mod('swimwear_shop_footerbg_color')); ?>;
	}
	

	</style>
	<?php 
}
endif;