<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Swimwear Shop
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
  wp_body_open();
} else {
  do_action( 'wp_body_open' );
} ?>

<?php if ( get_theme_mod('swimwear_shop_preloader', false) != "") { ?>
  <div id="preloader">
    <div id="status">&nbsp;</div>
  </div>
<?php }?>

<a class="screen-reader-text skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'swimwear-shop' ); ?></a>

<div id="pageholder" <?php if( get_theme_mod( 'swimwear_shop_box_layout', false) != "" ) { echo 'class="boxlayout"'; } ?>>

  <div class="mainhead <?php echo ( get_theme_mod( 'swimwear_shop_sticky_header', false ) == 1 ) ? 'header-sticky' : 'close-sticky'; ?>">
    <div class="header py-2">
      <div class="container">
        <div class="row m-0">
          <div class="col-lg-9 col-md-6 align-self-center">
            <div class="row">
              <div class="col-lg-3 col-md-6 align-self-center px-md-0">
                <div class="logo text-center text-md-start">
                  <?php if (get_theme_mod('swimwear_shop_logo_enable', true)) { ?>
                    <?php swimwear_shop_the_custom_logo(); ?>
                  <?php } ?>
                  <div class="site-branding-text">
                    <?php if (get_theme_mod('swimwear_shop_title_enable', false)) { ?>
                      <?php if (is_front_page() && is_home()) : ?>
                        <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
                      <?php else : ?>
                        <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
                      <?php endif; ?>
                    <?php } ?>
                    <?php $swimwear_shop_description = get_bloginfo('description', 'display');
                    if ($swimwear_shop_description || is_customize_preview()) : ?>
                      <?php if (get_theme_mod('swimwear_shop_tagline_enable', false)) { ?>
                        <span class="site-description"><?php echo esc_html($swimwear_shop_description); ?></span>
                      <?php } ?>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div class="col-lg-9 col-md-6 align-self-center">
                <div class="toggle-nav text-center">
                  <?php if (has_nav_menu('primary')) { ?>
                    <button role="tab"><?php esc_html_e('Menu', 'swimwear-shop'); ?></button>
                  <?php } ?>
                </div>
                <div id="mySidenav" class="nav sidenav px-lg-5">
                  <nav id="site-navigation" class="main-nav" role="navigation" aria-label="<?php esc_attr_e('Top Menu', 'swimwear-shop'); ?>">
                    <ul class="mobile_nav">
                      <?php wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'container_class' => 'main-menu',
                        'items_wrap' => '%3$s',
                        'fallback_cb' => 'wp_page_menu',
                      )); ?>
                    </ul>
                    <a href="javascript:void(0)" class="close-button"><?php esc_html_e('CLOSE', 'swimwear-shop'); ?></a>
                  </nav>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-md-6 align-self-center text-center text-md-end my-md-0 my-3 product-icon">
            <span class="search-box text-center me-3">
                <button type="button" class="search-open"><i class="fas fa-search"></i></button>
            </span>
            <?php if (class_exists('woocommerce')) { ?>
              <span class="product-account text-center me-3">
                <?php if (is_user_logged_in()) { ?>
                  <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>" title="<?php esc_attr_e('My Account', 'swimwear-shop'); ?>"><i class="far fa-user"></i></a>
                <?php } else { ?>
                  <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>" title="<?php esc_attr_e('Login / Register', 'swimwear-shop'); ?>"><i class="far fa-user"></i></a>
                <?php } ?>
              </span>
              <span class="wishlist pe-3">
                <?php 
                if (defined('YITH_WCWL') && class_exists('YITH_WCWL_Wishlists')) {
                    $swimwear_shop_wishlist_count = 0;
                    $swimwear_shop_wishlist_instance = YITH_WCWL_Wishlists::get_instance(); 
                    if ($swimwear_shop_wishlist_instance) {
                        $swimwear_shop_wishlist_count = $swimwear_shop_wishlist_instance->count_items_in_wishlist();
                    }
                ?>
                    <a class="wishlist_view position-relative" href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>">
                        <i class="far fa-heart"></i>
                        <span class="wishlist-count"><?php echo esc_html($swimwear_shop_wishlist_count); ?></span>
                    </a>
                <?php } else { ?>
                    <a class="wishlist_view position-relative" href="#">
                        <i class="far fa-heart"></i>
                        <span class="wishlist-count">0</span>
                    </a>
                <?php } ?>
              </span>
              <span class="product-cart text-center position-relative pe-2">
                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e('Shopping Cart', 'swimwear-shop'); ?>"><i class="fas fa-shopping-bag"></i></a>
                <?php $swimwear_shop_cart_count = WC()->cart->get_cart_contents_count(); ?>
                <?php if ($swimwear_shop_cart_count > 0) : ?>
                  <span class="cart-count"><?php echo esc_html($swimwear_shop_cart_count); ?></span>
                <?php endif; ?>
              </span>
               <?php if(get_theme_mod('swimwear_shop_header_currency_switcher', false) != ''){ ?>
                <span class="currency-box d-md-inline-block ps-3">
                  <?php echo do_shortcode('[woocommerce_currency_switcher_drop_down_box]'); ?>
                </span>
              <?php } ?>
            <?php } ?>
          </div>
          <div class="search-outer">
            <div class="serach_inner w-100 h-100">
              <?php get_search_form(); ?>
            </div>
            <button type="button" class="search-close"><span>X</span></button>
          </div>
        </div>
        </div>
      </div>
    </div>
  </div>