<?php
/**
 * Swimwear Shop functions and definitions
 *
 * @package Swimwear Shop
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

if ( ! function_exists( 'swimwear_shop_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function swimwear_shop_setup() {
	global $content_width;
	if ( ! isset( $content_width ) )
		$content_width = 680;

	load_theme_textdomain( 'swimwear-shop', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "responsive-embeds" );
	add_theme_support( 'align-wide' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'wp-block-styles');
	add_theme_support( 'custom-header', array(
		'default-text-color' => false,
		'header-text' => false,
	) );
	add_theme_support( 'custom-logo', array(
		'height'      => 100,
		'width'       => 100,
		'flex-height' => true,
	) );
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'swimwear-shop' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_editor_style( 'editor-style.css' );

	// Theme Activation Notice
	global $pagenow;

	if (
		is_admin()
		&&
		('themes.php' == $pagenow)
		// &&
		// isset( $_GET['activated'] )
	) {
		add_action('admin_notices', 'swimwear_shop_deprecated_hook_admin_notice');
	}
}
endif; // swimwear_shop_setup
add_action( 'after_setup_theme', 'swimwear_shop_setup' );

function swimwear_shop_the_breadcrumb() {
    echo '<div class="breadcrumb my-3">';

    if (!is_home()) {
        echo '<a class="home-main align-self-center" href="' . esc_url(home_url()) . '">';
        bloginfo('name');
        echo "</a>";

        if (is_category() || is_single()) {
            the_category(' ');
            if (is_single()) {
                echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
        }
    }

    echo '</div>';
}

function swimwear_shop_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'swimwear-shop' ),
		'description'   => __( 'Appears on blog page sidebar', 'swimwear-shop' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'swimwear-shop' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your sidebar on pages.', 'swimwear-shop' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'swimwear-shop' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'swimwear-shop' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	$swimwear_shop_widget_areas = get_theme_mod('swimwear_shop_footer_widget_areas', '4');
	for ($swimwear_shop_i=1; $swimwear_shop_i <= 4; $swimwear_shop_i++) {
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'swimwear-shop' ) . $swimwear_shop_i,
			'id'            => 'footer-' . $swimwear_shop_i,
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	register_sidebar(array(
        'name'          => __('Shop Sidebar', 'swimwear-shop'),
        'description'   => __('Sidebar for WooCommerce shop pages', 'swimwear-shop'),
		'id'            => 'woocommerce_sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
	register_sidebar(array(
        'name'          => __('Single Product Sidebar', 'swimwear-shop'),
        'description'   => __('Sidebar for single product pages', 'swimwear-shop'),
		'id'            => 'woocommerce-single-sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
}
add_action( 'widgets_init', 'swimwear_shop_widgets_init' );

// Change number of products per row to 4
add_filter('loop_shop_columns', 'swimwear_shop_loop_columns');
if (!function_exists('swimwear_shop_loop_columns')) {
    function swimwear_shop_loop_columns() {
        $swimwear_shop_colm = get_theme_mod('swimwear_shop_products_per_row', 4); // Default to 4 if not set
        return $swimwear_shop_colm;
    }
}

// Use the customizer setting to set the number of products per page
function swimwear_shop_products_per_page($swimwear_shop_cols) {
    $swimwear_shop_cols = get_theme_mod('swimwear_shop_products_per_page', 9); // Default to 9 if not set
    return $swimwear_shop_cols;
}
add_filter('loop_shop_per_page', 'swimwear_shop_products_per_page', 9);

function swimwear_shop_scripts() {

	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri())."/css/bootstrap.css" );
	wp_enqueue_style('swimwear-shop-style', get_stylesheet_uri(), array() );
		wp_style_add_data('swimwear-shop-style', 'rtl', 'replace');

	require get_parent_theme_file_path( '/inc/color-scheme/custom-color-control.php' );
	wp_add_inline_style( 'swimwear-shop-style',$swimwear_shop_color_scheme_css );
	wp_enqueue_style( 'owl.carousel-css', esc_url(get_template_directory_uri())."/css/owl.carousel.css" );
	wp_enqueue_style( 'swimwear-shop-default', esc_url(get_template_directory_uri())."/css/default.css" );	
	wp_enqueue_style( 'swimwear-shop-style', get_stylesheet_uri() );
	wp_enqueue_style( 'animate-style', get_template_directory_uri().'/css/animate.css' );
	wp_enqueue_script( 'wow-jquery', get_template_directory_uri() . '/js/wow.js', array('jquery'),'' ,true );
	wp_enqueue_script( 'owl.carousel-js', esc_url(get_template_directory_uri()). '/js/owl.carousel.js', array('jquery') );
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()). '/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'swimwear-shop-theme', esc_url(get_template_directory_uri()) . '/js/theme.js' );
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/css/fontawesome-all.css" );
	wp_enqueue_style( 'swimwear-shop-block-style', esc_url( get_template_directory_uri() ).'/css/blocks.css' );	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// font-family
	$swimwear_shop_headings_font = esc_html(get_theme_mod('swimwear_shop_headings_fonts'));
	$swimwear_shop_body_font = esc_html(get_theme_mod('swimwear_shop_body_fonts'));

	if ($swimwear_shop_headings_font) {
	    wp_enqueue_style('swimwear-shop-headings-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($swimwear_shop_headings_font));
	} else {
	    wp_enqueue_style('josefin-sans-heading', 'https://fonts.googleapis.com/css?family=Josefin+Sans:wght@0,100..700;1,100..700');
	}

	if ($swimwear_shop_body_font) {
	    wp_enqueue_style('swimwear-shop-body-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($swimwear_shop_body_font));
	} else {
	    wp_enqueue_style('josefin-sans-body', 'https://fonts.googleapis.com/css?family=Josefin+Sans:ital,wght@0,100..700;1,100..700');
	}

}
add_action( 'wp_enqueue_scripts', 'swimwear_shop_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Sanitization Callbacks.
 */
require get_template_directory() . '/inc/sanitization-callbacks.php';

/**
 * Webfont-Loader.
 */
require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/inc/gfonts.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/upgrade-to-pro.php';

/**
 * select .
 */
require get_template_directory() . '/inc/select/category-dropdown-custom-control.php';

/**
 * Load TGM.
 */
require get_template_directory() . '/inc/tgm/tgm.php';

/**
 * Theme Info Page.
 */
require get_template_directory() . '/inc/addon.php';

function swimwear_shop_setup_theme() {
	// Footer Link
	define('SWIMWEAR_SHOP_FOOTER_LINK',__('https://www.theclassictemplates.com/products/free-swimwear-wordpress-theme','swimwear-shop'));
	if ( ! defined( 'SWIMWEAR_SHOP_PRO_NAME' ) ) {
		define( 'SWIMWEAR_SHOP_PRO_NAME', __( 'About Swimwear Shop', 'swimwear-shop' ));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_PREMIUM_PAGE' ) ) {
	define('SWIMWEAR_SHOP_PREMIUM_PAGE',__('https://www.theclassictemplates.com/products/swimming-costume-wordpress-theme','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_THEME_PAGE' ) ) {
	define('SWIMWEAR_SHOP_THEME_PAGE',__('https://www.theclassictemplates.com/collections/best-wordpress-templates','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_SUPPORT' ) ) {
	define('SWIMWEAR_SHOP_SUPPORT',__('https://wordpress.org/support/theme/swimwear-shop/','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_REVIEW' ) ) {
	define('SWIMWEAR_SHOP_REVIEW',__('https://wordpress.org/support/theme/swimwear-shop/reviews/','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_PRO_DEMO' ) ) {
	define('SWIMWEAR_SHOP_PRO_DEMO',__('https://live.theclassictemplates.com/swimwear-shop-pro/','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_THEME_DOCUMENTATION' ) ) {
	define('SWIMWEAR_SHOP_THEME_DOCUMENTATION',__('https://live.theclassictemplates.com/demo/docs/swimwear-shop-free/','swimwear-shop'));
	}
	if ( ! defined( 'SWIMWEAR_SHOP_BUNDLE_PAGE' ) ) {
		define('SWIMWEAR_SHOP_BUNDLE_PAGE',__('https://www.theclassictemplates.com/products/wordpress-theme-bundle','swimwear-shop'));
	}
}
add_action( 'after_setup_theme', 'swimwear_shop_setup_theme' );

/* Starter Content */
	add_theme_support( 'starter-content', array(
		'widgets' => array(
			'footer-1' => array(
				'categories',
			),
			'footer-2' => array(
				'archives',
			),
			'footer-3' => array(
				'meta',
			),
			'footer-4' => array(
				'search',
			),
		),
    ));
    
// logo
if ( ! function_exists( 'swimwear_shop_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 */
function swimwear_shop_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;

/* Activation Notice */
function swimwear_shop_deprecated_hook_admin_notice() {
	 $swimwear_shop_theme = wp_get_theme();
	$swimwear_shop_meta = get_option( 'swimwear_shop_admin_notice' );

	if (!$swimwear_shop_meta) {
    ?>
        <div id="swimwear-shop-welcome-notice" class="getstrat updated notice notice-success welcome-notice is-dismissible notice-get-started-class">
            <div class="admin-image">
                <img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
            <div class="admin-content" >
                <h1><?php 
				/* translators: 1: Theme name, 2: Theme version. */
				printf( esc_html__( 'Welcome to %1$s %2$s', 'swimwear-shop' ), esc_html($swimwear_shop_theme->get( 'Name' )), esc_html($swimwear_shop_theme->get( 'Version' ))); ?>
                </h1>
                <p><?php _e('Get Started With Theme By Clicking On Getting Started.', 'swimwear-shop'); ?></p>
                <div style="display: grid;">
                    <a class="admin-notice-btn button button-hero upgrade-pro" target="_blank" href="<?php echo esc_url( SWIMWEAR_SHOP_PREMIUM_PAGE ); ?>"><?php esc_html_e('Upgrade Pro', 'swimwear-shop') ?><i class="dashicons dashicons-cart"></i></a>
                    <a class="admin-notice-btn button button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=swimwear-shop' )); ?>"><?php esc_html_e( 'Get started', 'swimwear-shop' ) ?><i class="dashicons dashicons-backup"></i></a>
                    <a class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( SWIMWEAR_SHOP_THEME_DOCUMENTATION ); ?>"><?php esc_html_e('Free Doc', 'swimwear-shop') ?><i class="dashicons dashicons-visibility"></i></a>
                    <a  class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( SWIMWEAR_SHOP_PRO_DEMO ); ?>"><?php esc_html_e('View Demo', 'swimwear-shop') ?><i class="dashicons dashicons-awards"></i></a>
                </div>
            </div>
			<div class="admin-bundle-image">
				<a href="<?php echo esc_url( SWIMWEAR_SHOP_BUNDLE_PAGE ); ?>" target="_blank"><img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/images/image_1.webp'; ?>" /></a>
			</div>
        </div>
	<?php
    }
}
// Admin notice code START
function swimwear_shop_dismissed_notice() {
	update_option( 'swimwear_shop_admin_notice', true );
}
add_action( 'wp_ajax_swimwear_shop_dismissed_notice', 'swimwear_shop_dismissed_notice' );


//After Switch theme function
add_action('after_switch_theme', 'swimwear_shop_getstart_setup_options');
function swimwear_shop_getstart_setup_options () {
    update_option('swimwear_shop_admin_notice', false );
}
// Admin notice code END

add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );