<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Swimwear Shop
 */
?>
<div id="footer">
  <?php 
    $swimwear_shop_footer_widget_enabled = get_theme_mod('swimwear_shop_footer_widget', true);
    
    if ($swimwear_shop_footer_widget_enabled !== false && $swimwear_shop_footer_widget_enabled !== '') { ?>

    <?php 
        $swimwear_shop_widget_areas = get_theme_mod('swimwear_shop_footer_widget_areas', '4');
        if ($swimwear_shop_widget_areas == '3') {
            $swimwear_shop_cols = 'col-lg-4 col-md-6';
        } elseif ($swimwear_shop_widget_areas == '4') {
            $swimwear_shop_cols = 'col-lg-3 col-md-6';
        } elseif ($swimwear_shop_widget_areas == '2') {
            $swimwear_shop_cols = 'col-lg-6 col-md-6';
        } else {
            $swimwear_shop_cols = 'col-lg-12 col-md-12';
        }
    ?>

    <div class="footer-widget">
        <div class="container">
          <div class="row wow bounceInUp delay-3000" data-wow-duration="2s">
            <!-- Footer 1 -->
            <div class="<?php echo esc_attr($swimwear_shop_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-1')) : ?>
                    <?php dynamic_sidebar('footer-1'); ?>
                <?php else : ?>
                    <aside id="categories" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'swimwear-shop'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Categories', 'swimwear-shop'); ?></h3>
                        <ul>
                            <?php wp_list_categories('title_li='); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 2 -->
            <div class="<?php echo esc_attr($swimwear_shop_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-2')) : ?>
                    <?php dynamic_sidebar('footer-2'); ?>
                <?php else : ?>
                    <aside id="archives" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'swimwear-shop'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Archives', 'swimwear-shop'); ?></h3>
                        <ul>
                            <?php wp_get_archives(array('type' => 'monthly')); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 3 -->
            <div class="<?php echo esc_attr($swimwear_shop_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-3')) : ?>
                    <?php dynamic_sidebar('footer-3'); ?>
                <?php else : ?>
                    <aside id="meta" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'swimwear-shop'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Meta', 'swimwear-shop'); ?></h3>
                        <ul>
                            <?php wp_register(); ?>
                            <li><?php wp_loginout(); ?></li>
                            <?php wp_meta(); ?>
                        </ul>
                    </aside>
                <?php endif; ?>
            </div>

            <!-- Footer 4 -->
            <div class="<?php echo esc_attr($swimwear_shop_cols); ?> footer-block">
                <?php if (is_active_sidebar('footer-4')) : ?>
                    <?php dynamic_sidebar('footer-4'); ?>
                <?php else : ?>
                    <aside id="search-widget" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'swimwear-shop'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Search', 'swimwear-shop'); ?></h3>
                        <?php the_widget('WP_Widget_Search'); ?>
                    </aside>
                <?php endif; ?>
            </div>
          </div>
        </div>
    </div>

    <?php } ?>
    <div class="clear"></div>
  <div class="copywrap text-center">
    <?php $swimwear_shop_social_links_present = get_theme_mod('swimwear_shop_footer_facebook_link') || get_theme_mod('swimwear_shop_footer_instagram_link') || get_theme_mod('swimwear_shop_footer_pinterest_link') || get_theme_mod('swimwear_shop_footer_twitter_link') || get_theme_mod('swimwear_shop_footer_youtube_link'); ?>
    <div class="container copywrap-info <?php echo $swimwear_shop_social_links_present ? '' : 'center-content'; ?>">
        <p>
        <a href="<?php 
            $swimwear_shop_copyright_link = get_theme_mod('swimwear_shop_copyright_link', '');
            if (empty($swimwear_shop_copyright_link)) {
                echo esc_url('https://www.theclassictemplates.com/products/free-swimwear-wordpress-theme');
            } else {
                echo esc_url($swimwear_shop_copyright_link);
            } ?>" target="_blank">
            <?php echo esc_html(get_theme_mod('swimwear_shop_copyright_line', __('Swimwear Shop WordPress Theme', 'swimwear-shop'))); ?>
        </a> 
        <?php echo esc_html('By Classic Templates', 'swimwear-shop'); ?>
        </p>
        <?php if ( $swimwear_shop_social_links_present ) { ?>
            <div class="footer-social d-flex gap-3">
                <?php if ( get_theme_mod('swimwear_shop_footer_facebook_link') ) { ?>
                    <a title="<?php echo esc_attr('facebook', 'swimwear-shop'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('swimwear_shop_footer_facebook_link')); ?>"><i class="fa-brands fa-facebook-f"></i></a> 
                <?php } ?>
                <?php if ( get_theme_mod('swimwear_shop_footer_instagram_link') ) { ?> 
                    <a title="<?php echo esc_attr('instagram', 'swimwear-shop'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('swimwear_shop_footer_instagram_link')); ?>"><i class="fa-brands fa-instagram"></i></a>
                <?php } ?>
                <?php if ( get_theme_mod('swimwear_shop_footer_pinterest_link') ) { ?>
                    <a title="<?php echo esc_attr('pinterest', 'swimwear-shop'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('swimwear_shop_footer_pinterest_link')); ?>"><i class="fa-brands fa-pinterest"></i></a>
                <?php } ?>
                <?php if ( get_theme_mod('swimwear_shop_footer_twitter_link') ) { ?> 
                    <a title="<?php echo esc_attr('twitter', 'swimwear-shop'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('swimwear_shop_footer_twitter_link')); ?>"><i class="fa-brands fa-twitter"></i></a>
                <?php } ?>
                <?php if ( get_theme_mod('swimwear_shop_footer_youtube_link') ) { ?>
                    <a title="<?php echo esc_attr('youtube', 'swimwear-shop'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('swimwear_shop_footer_youtube_link')); ?>"><i class="fa-brands fa-youtube"></i></a>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
    </div>
  </div>
</div>

<?php if(get_theme_mod('swimwear_shop_scroll_hide',true)){ ?>
    <a id="button"><?php echo esc_html( get_theme_mod('swimwear_shop_scroll_text',__('TOP', 'swimwear-shop' )) ); ?></a>
<?php } ?>
  
<?php wp_footer(); ?>
</body>
</html>
