<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Swiftly
 * 
 * @since 1.0
*/


/**
 * Customizers additions.
*/
require get_stylesheet_directory() . '/customizers.php';


add_action( 'wp_enqueue_scripts', 'swiftly_enqueue_styles' );
function swiftly_enqueue_styles() {

    wp_enqueue_style( 'swiftly-animate', get_stylesheet_directory_uri() . '/css/animate.css' );

    wp_enqueue_style( 'swiftly-owl.carousel', get_stylesheet_directory_uri() . '/css/owl.carousel.css' );

    wp_enqueue_style( 'swiftly-owl.theme.default', get_stylesheet_directory_uri() . '/css/owl.theme.default.css' );

    wp_enqueue_style( 'swiftly-magnific-popup', get_stylesheet_directory_uri() . '/css/magnific-popup.css' );

    wp_enqueue_style( 'swiftly-bootstrap', get_stylesheet_directory_uri() . '/css/bootstrap.css' );

    wp_enqueue_style( 'swiftly-parent-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style( 
        'swiftly-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('swiftly-parent-style')
    );

    wp_enqueue_script('swiftly-popper', get_stylesheet_directory_uri() .'/js/popper.min.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-bootstrap', get_stylesheet_directory_uri() .'/js/bootstrap.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-easing', get_stylesheet_directory_uri() .'/js/jquery.easing.1.3.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-jquery.waypoints', get_stylesheet_directory_uri() .'/js/jquery.waypoints.min.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-jquery.stellar', get_stylesheet_directory_uri() .'/js/jquery.stellar.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-owl.carousel', get_stylesheet_directory_uri() .'/js/owl.carousel.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-jquery.magnific-popup', get_stylesheet_directory_uri() .'/js/jquery.magnific-popup.min.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-jquery.animateNumber', get_stylesheet_directory_uri() .'/js/jquery.animateNumber.min.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-scrollax', get_stylesheet_directory_uri() .'/js/scrollax.min.js', array('jquery'), true, true );

    wp_enqueue_script('swiftly-main', get_stylesheet_directory_uri() .'/js/main.js', array('jquery'), true, true );
	
	

// Include google webfont locally //
	require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );
	
	$font_families = array(
		'Open Sans:wght@300;400;600;700;900'
	);

	$fonts_url = add_query_arg( array(
		'family' => implode( '&family=', $font_families ),
		'display' => 'swap',
		'subset' => 'latin,latin-ext',
	), 'https://fonts.googleapis.com/css2' );
	
	$contents = wptt_get_webfont_url( esc_url_raw( $fonts_url ) );
	
	// Load the webfont.
	wp_enqueue_style(
		'Open Sans',
		$contents,
		array(),
		'1.0'
	);
}

function swiftly_​remove_starkers_styles() {

    // Remove Css File --> "enigma-theme-animtae" Parent Styles
    wp_dequeue_style( 'enigma-theme-animtae', get_template_directory_uri() . '/css/theme-animtae.css' );

    // Remove JS File --> "enigma-theme-animtae" Parent Styles
    wp_dequeue_script( 'enigma-footer-script', get_template_directory_uri() .'/js/enigma-footer-script.js', array('jquery'), true, true  );

}
add_action( 'wp_enqueue_scripts','swiftly_​remove_starkers_styles', 20 );



/**
	 * For Welcome admin notice File...
	*/
	require get_stylesheet_directory() . '/inc/class-back-to-top-customize.php';


/*
 * Your code goes below
*/
function swiftly_add_editor_styles() {
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'swiftly_add_editor_styles' );

add_action('widgets_init', 'swiftly_widgets_init');
function swiftly_widgets_init() {

    /* Sidebar Widget Area */
     register_sidebar(array(
        'name'          => esc_html__('Sidebar', 'swiftly'),
        'id'            => 'sidebar-primary',
        'description'   => esc_html__('The primary widget area', 'swiftly'),
        'before_widget' => '<div class="enigma_sidebar_widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<div class="enigma_sidebar_widget_title"><h2>',
        'after_title'   => '</h2></div>'
    ));

    /* footer Widget Area */
    register_sidebar(array(
        'name'          => esc_html__('Footer Widget Area', 'swiftly'),
        'id'            => 'footer-widget-area',
        'description'   => esc_html__('footer widget area', 'swiftly'),
        'before_widget' => '<div class="col-md-3 col-sm-6 enigma_footer_widget_column %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<div class="enigma_footer_widget_title">',
        'after_title'   => '<div class="enigma-footer-separator"></div></div>',
    ));

}
