<?php


/***
    *** Register Customizer Add Panel Function Code start Here
***/
function swiftly_Theme_Register_Customizer_Add_Panel_Function( $wp_customize ) {

	// Create Custom Aanel for Home Page.
	$wp_customize->add_panel( 'swiftly_Theme_Custom_Add_Panel_Function', array(
		'theme_supports' => '',
		'title'          => __( ' Swiftly Theme Options ', 'swiftly' ),
		'priority' => 1,
	) ); 
	
	
}
add_action( 'customize_register', 'swiftly_Theme_Register_Customizer_Add_Panel_Function' );
/***
    *** Register Customizer Add Panel Function Code END Here
***/



/***
    *** Register Customizer 404 Page Section Code start Here
***/
class swiftly_404_Page_Section_Customizer {

	public static function swiftly_Register_Theme_Customizer_For_404_Page_Section( $wp_customize ) {

		// Add 404 Page Section
		$wp_customize->add_section( 'swiftly_Theme_Section_For_404_Page_Section' , array(
			'title'    => __(' 404 Page Section ','swiftly'),
			'panel' => 'swiftly_Theme_Custom_Add_Panel_Function',
		) );

		/*******************************************************************************
		                    404 Page Section Title
		********************************************************************************/
		$wp_customize->add_setting( 'swiftly_Setting_For_404_Page_Section_Title', array(
			'sanitize_callback' => 'swiftly_404_Page_Section_Page_Sanitize_Text',
		 ) );
 
		 // Add 04 Page Main Title Section Title Add control
		 $wp_customize->add_control( new WP_Customize_Control(
			 $wp_customize,
			 'swiftly_Setting_For_404_Page_Section_Title',
				 array(
					 'label'    => __( ' 404 Page Main Title ', 'swiftly' ),
					 'section'  => 'swiftly_Theme_Section_For_404_Page_Section',
					 'settings' => 'swiftly_Setting_For_404_Page_Section_Title',
					 'type'     => 'text',
					 'priority' => 1,
				 )
			 )
		 );

		/*******************************************************************************
		                    404 Page Section For Button Label In 404 Page
		********************************************************************************/
		$wp_customize->add_setting( 'swiftly_Setting_For_404_Page_Section_Button_Label', array(
	       'sanitize_callback' => 'swiftly_404_Page_Section_Page_Sanitize_Text',
		) );

		// Add 404 Page Section Button Label Add control
		$wp_customize->add_control( new WP_Customize_Control(
		    $wp_customize,
			'swiftly_Theme_404_Page_Section',
			    array(
			        'label'    => __( ' Button Label For 404 Page ', 'swiftly' ),
			        'section'  => 'swiftly_Theme_Section_For_404_Page_Section',
			        'settings' => 'swiftly_Setting_For_404_Page_Section_Button_Label',
			        'type'     => 'text',
			        'priority' => 1,
			    )
		    )
		);

		/*******************************************************************************
		                    404 Page Section Title Description Code 
		********************************************************************************/
		$wp_customize->add_setting( 'swiftly_Setting_For_404_Page_Section_Description', array(
	       'sanitize_callback' => 'swiftly_404_Page_Section_Page_Sanitize_Text',
		) );

		// Add 404 Page Section Description Add control
		$wp_customize->add_control( new WP_Customize_Control(
		    $wp_customize,
			'swiftly_Setting_For_404_Page_Section_Description',
			    array(
			        'label'    => __( ' 404 Page Description ', 'swiftly' ),
			        'section'  => 'swiftly_Theme_Section_For_404_Page_Section',
			        'settings' => 'swiftly_Setting_For_404_Page_Section_Description',
			        'type'     => 'textarea',
			        'priority' => 2,
			    )
		    )
		);

		// Add Settings For 404 Page Button
		$wp_customize->add_setting( 'swiftly_404_Page_Button_background', array(
			'default' => '#f4c201',
			'sanitize_callback' => 'swiftly_404_Page_sanitize_color',

		));

		// Add Controls For 404 Page Button
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'swiftly_404_Page_Button_background', array(
			'label' => '404 Page Button background',
			'section' => 'swiftly_Theme_Section_For_404_Page_Section',
			'settings' => 'swiftly_404_Page_Button_background'
		)));

		/**
		 * Color sanitization callback
		*/
		function swiftly_404_Page_sanitize_color( $color ) {
			if ( empty( $color ) || is_array( $color ) ) {
				return '';
			}

			// If string does not start with 'rgba', then treat as hex.
			// sanitize the hex color and finally convert hex to rgba
			if ( false === strpos( $color, 'rgba' ) ) {
				return sanitize_hex_color( $color );
			}

			// By now we know the string is formatted as an rgba color so we need to further sanitize it.
			$color = str_replace( ' ', '', $color );
			sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

			return 'rgba('.$red.','.$green.','.$blue.','.$alpha.')';
		}
		 
		/**
		 * Text sanitization callback
		*/
		function swiftly_404_Page_Section_Page_Sanitize_Text( $text ) {
		    return sanitize_text_field( $text );
		}	

	}
}
add_action( 'customize_register', array('swiftly_404_Page_Section_Customizer', 'swiftly_Register_Theme_Customizer_For_404_Page_Section') );
/***
    *** Register Customizer 404 Page Section Code End Here
***/
?>