<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package swiftly
*/

get_header();
$page_header = absint(get_theme_mod( 'page_header', 1 ));
$class = '';
if ( $page_header == 1) { ?>
    <div class="enigma_header_breadcrum_title">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1><?php esc_html_e('404 Error', 'enigma'); ?></h1>
                    <ul class="breadcrumb">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home', 'enigma'); ?></a>
                        </li>
                        <li><?php esc_html_e('404 Error', 'enigma'); ?></li>

                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php } else {
    $class = 'no-page-header';
} ?>

<div class="page-not-found space">
    <div class="container">
        <div class="row">
            <div class="col-md-12 no-data">
                <h2>
                   <?php if ( get_theme_mod( "swiftly_Setting_For_404_Page_Section_Title" ) ) 
                    {
                        echo esc_html(get_theme_mod( "swiftly_Setting_For_404_Page_Section_Title" ));
                    } else{ 
                        echo esc_html__('404', 'swiftly');
                    }?> 
                    <?php //echo esc_html__('404', 'swiftly') ?></h2>
                <h4>
                    <?php if ( get_theme_mod( "swiftly_Setting_For_404_Page_Section_Description" ) ) 
                    {
                        echo esc_html(get_theme_mod( "swiftly_Setting_For_404_Page_Section_Description" ));
                    } else{ 
                        echo esc_html__('PAGE NOT FOUND', 'swiftly');
                    }?> 
                </h4>
                <?php $swiftly_404_Page_Button_background = get_theme_mod('swiftly_404_Page_Button_background');
                if( !empty($swiftly_404_Page_Button_background) ) : ?>

                    <style type="text/css" id="diwp-theme-option-css">
                        
                        .page-not-found .send-btn {
                            background-color: <?php echo $swiftly_404_Page_Button_background; ?> !important;
                            color: #fff;
                            border-radius: 0px;
                            padding: 14px 25px;
    font-size: 20px;
    font-weight: 700;
    text-decoration: none;
                            text-decoration: none;
                        }
                    
                    </style>    
            
                <?php
            
                endif; ?>

                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class=" send-btn">
                    <?php if ( get_theme_mod( "swiftly_Setting_For_404_Page_Section_Button_Label" ) ) 
                    {
                        echo esc_html(get_theme_mod( "swiftly_Setting_For_404_Page_Section_Button_Label" ));
                    } else{ 
                        echo esc_html__('Back To Home', 'swiftly');
                    }?>  
                </a>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>