<div class="banner-trending-area">
	<?php
	$trending_topic_query = new WP_Query( $trending_args );
	if ( $trending_topic_query->have_posts() ) {
		$section_title = get_theme_mod( 'swift_news_trending_topic_title', __( 'Top 5 This Week', 'swift-news' ) );
		?>
		<div class="trending-topics">
			<?php if ( ! empty( $section_title ) ) { ?>
				<div class="title-heading">
					<h3 class="trending-topics-title"><?php echo esc_html( $section_title ); ?></h3>
				</div>
			<?php } ?>
			<div class="trending-topics-wrapper">
				<?php
				$i = 1;
				while ( $trending_topic_query->have_posts() ) :
					$trending_topic_query->the_post();
					?>
					<div class="blog-post-container list-layout">
						<div class="blog-post-inner">
							<?php if ( has_post_thumbnail() ) { ?>
								<div class="blog-post-image">
									<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
								</div>
							<?php } ?>
							<div class="blog-post-detail">
								<h2 class="entry-title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h2>
								<div class="post-meta">
									<?php swift_news_posted_on(); ?>
								</div>
								<span class="counter"><?php echo absint( $i ); ?></span>
							</div>
						</div>
					</div>
					<?php
					$i++;
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
		<?php
	}
	require get_template_directory() . '/template-parts/sections/banner/top-news.php';
	?>
</div>
