<?php
$main_news_query = new WP_Query( $main_news_args );
if ( $main_news_query->have_posts() ) {
	?>
	<div class="banner-main-part">
		<div class="banner-main-part-wrapper">
			<?php
			while ( $main_news_query->have_posts() ) :
				$main_news_query->the_post();
				?>
				<div class="blog-post-container grid-layout">
					<div class="blog-post-inner">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="blog-post-image">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'full' ); ?></a>
							</div>
						<?php } ?>
						<div class="blog-post-detail">
							<h2 class="entry-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h2>
							<?php swift_news_categories_list(); ?>
							<div class="post-meta">
								<?php
								swift_news_posted_by();
								swift_news_posted_on();
								?>
							</div>
							<p class="post-excerpt">
								<?php echo wp_kses_post( wp_trim_words( get_the_content(), 20 ) ); ?>
							</p>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
