<?php
$editor_query = new WP_Query( $editor_args );
if ( $editor_query->have_posts() ) {
	?>
	<div class="editors-choice">
		<div class="editors-choice-wrap">
			<?php
			while ( $editor_query->have_posts() ) :
				$editor_query->the_post();
				?>
				<div class="blog-post-container tile-layout">
					<div class="blog-post-inner">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="blog-post-image">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
							</div>
						<?php } ?>
						<div class="blog-post-detail">
							<h2 class="entry-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h2>
							<?php swift_news_categories_list( true ); ?>
							<div class="post-meta">
								<?php
								swift_news_posted_by();
								swift_news_posted_on();
								?>
							</div>
							<?php if ( ! has_post_thumbnail() ) : ?>
								<p class="post-excerpt">
									<?php echo wp_kses_post( wp_trim_words( get_the_content(), 20 ) ); ?>
								</p>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
