<?php
/**
 * Typography
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_typography',
	array(
		'panel' => 'swift_news_theme_options',
		'title' => esc_html__( 'Typography', 'swift-news' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'swift_news_site_title_font',
	array(
		'default'           => 'Open Sans',
		'sanitize_callback' => 'swift_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'swift_news_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'swift-news' ),
		'section'  => 'swift_news_typography',
		'settings' => 'swift_news_site_title_font',
		'type'     => 'select',
		'choices'  => swift_news_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'swift_news_site_description_font',
	array(
		'default'           => 'Roboto',
		'sanitize_callback' => 'swift_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'swift_news_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'swift-news' ),
		'section'  => 'swift_news_typography',
		'settings' => 'swift_news_site_description_font',
		'type'     => 'select',
		'choices'  => swift_news_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'swift_news_header_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'swift_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'swift_news_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'swift-news' ),
		'section'  => 'swift_news_typography',
		'settings' => 'swift_news_header_font',
		'type'     => 'select',
		'choices'  => swift_news_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'swift_news_body_font',
	array(
		'default'           => 'Roboto',
		'sanitize_callback' => 'swift_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'swift_news_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'swift-news' ),
		'section'  => 'swift_news_typography',
		'settings' => 'swift_news_body_font',
		'type'     => 'select',
		'choices'  => swift_news_get_all_google_font_families(),
	)
);
