<?php
/**
 * Sidebar Option
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_sidebar_option',
	array(
		'title' => esc_html__( 'Layout', 'swift-news' ),
		'panel' => 'swift_news_theme_options',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'swift_news_sidebar_position',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'swift_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'swift-news' ),
		'section' => 'swift_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'swift-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'swift-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'swift_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'swift_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'swift-news' ),
		'section' => 'swift_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'swift-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'swift-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'swift_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'swift_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'swift-news' ),
		'section' => 'swift_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'swift-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'swift-news' ),
		),
	)
);
