<?php
/**
 * Post Options
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'swift-news' ),
		'panel' => 'swift_news_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'swift_news_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'swift-news' ),
			'section' => 'swift_news_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'swift_news_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'swift-news' ),
			'section' => 'swift_news_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'swift_news_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'swift-news' ),
			'section' => 'swift_news_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'swift_news_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'swift-news' ),
			'section' => 'swift_news_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'swift_news_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'swift-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'swift_news_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'swift-news' ),
		'section'  => 'swift_news_post_options',
		'settings' => 'swift_news_post_related_post_label',
		'type'     => 'text',
	)
);
