<?php
/**
 * Pagination
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_pagination',
	array(
		'panel' => 'swift_news_theme_options',
		'title' => esc_html__( 'Pagination', 'swift-news' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'swift_news_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'swift-news' ),
			'section'  => 'swift_news_pagination',
			'settings' => 'swift_news_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'swift_news_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'swift-news' ),
		'section'         => 'swift_news_pagination',
		'settings'        => 'swift_news_pagination_type',
		'active_callback' => 'swift_news_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'swift-news' ),
			'numeric' => __( 'Numeric', 'swift-news' ),
		),
	)
);
