<?php
/**
 * Header Options
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_header_options',
	array(
		'panel' => 'swift_news_theme_options',
		'title' => esc_html__( 'Header Options', 'swift-news' ),
	)
);

// Header Section - Enable Topbar Section.
$wp_customize->add_setting(
	'swift_news_enable_topbar_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_enable_topbar_section',
		array(
			'label'    => esc_html__( 'Enable Topbar Section', 'swift-news' ),
			'section'  => 'swift_news_header_options',
			'settings' => 'swift_news_enable_topbar_section',
		)
	)
);

// Header Options - Advertisement.
$wp_customize->add_setting(
	'swift_news_header_advertisement',
	array(
		'default'           => '',
		'sanitize_callback' => 'swift_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'swift_news_header_advertisement',
		array(
			'label'    => esc_html__( 'Advertisement', 'swift-news' ),
			'section'  => 'swift_news_header_options',
			'settings' => 'swift_news_header_advertisement',
		)
	)
);

	// Header Options - Advertisement URL.
$wp_customize->add_setting(
	'swift_news_header_advertisement_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'swift_news_header_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'swift-news' ),
		'section'  => 'swift_news_header_options',
		'settings' => 'swift_news_header_advertisement_url',
		'type'     => 'url',
	)
);
