<?php
/**
 * Excerpt
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_excerpt_options',
	array(
		'panel' => 'swift_news_theme_options',
		'title' => esc_html__( 'Excerpt', 'swift-news' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'swift_news_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'swift_news_sanitize_number_range',
		'validate_callback' => 'swift_news_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'swift_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'swift-news' ),
		'description' => esc_html__( 'Note: Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'swift-news' ),
		'section'     => 'swift_news_excerpt_options',
		'settings'    => 'swift_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 100,
			'step' => 1,
		),
	)
);
