<?php
/**
 * Breadcrumb
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'swift-news' ),
		'panel' => 'swift_news_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'swift_news_enable_breadcrumb',
	array(
		'sanitize_callback' => 'swift_news_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'swift-news' ),
			'section' => 'swift_news_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'swift_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'swift_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'swift-news' ),
		'active_callback' => 'swift_news_is_breadcrumb_enabled',
		'section'         => 'swift_news_breadcrumb',
	)
);
