<?php
/**
 * Archive Layout
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_archive_layout',
	array(
		'title' => esc_html__( 'Archive Layout', 'swift-news' ),
		'panel' => 'swift_news_theme_options',
	)
);

// Archive Layout - Column Layout.
$wp_customize->add_setting(
	'swift_news_archive_column_layout',
	array(
		'default'           => 'column-2',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_archive_column_layout',
	array(
		'label'   => esc_html__( 'Column Layout', 'swift-news' ),
		'section' => 'swift_news_archive_layout',
		'type'    => 'select',
		'choices' => array(
			'column-2' => __( 'Column 2', 'swift-news' ),
			'column-3' => __( 'Column 3', 'swift-news' ),
		),
	)
);
