<?php
/**
 * Banner Section
 *
 * @package Swift News
 */

$wp_customize->add_section(
	'swift_news_banner_section',
	array(
		'panel' => 'swift_news_front_page_options',
		'title' => esc_html__( 'Banner Section', 'swift-news' ),
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'swift_news_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'swift_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Swift_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'swift_news_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'swift-news' ),
			'section'  => 'swift_news_banner_section',
			'settings' => 'swift_news_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'swift_news_enable_banner_section',
		array(
			'selector' => '#swift_news_banner_section .section-link',
			'settings' => 'swift_news_enable_banner_section',
		)
	);
}

// Banner Section - Main News Content Type.
$wp_customize->add_setting(
	'swift_news_main_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_main_news_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_main_news_content_type',
		'type'            => 'select',
		'active_callback' => 'swift_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'swift-news' ),
			'category' => esc_html__( 'Category', 'swift-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'swift_news_main_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'swift_news_main_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'swift-news' ), $i ),
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_main_news_content_post_' . $i,
			'active_callback' => 'swift_news_is_main_news_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => swift_news_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'swift_news_main_news_content_category',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_main_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_main_news_content_category',
		'active_callback' => 'swift_news_is_main_news_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => swift_news_get_post_cat_choices(),
	)
);

// Banner Section - Horizontal Line.
$wp_customize->add_setting(
	'swift_news_main_news_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Swift_News_Customize_Horizontal_Line(
		$wp_customize,
		'swift_news_main_news_horizontal_line',
		array(
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_main_news_horizontal_line',
			'active_callback' => 'swift_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);

// Banner Section - Editor Choice Content Type.
$wp_customize->add_setting(
	'swift_news_editor_choice_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_editor_choice_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_editor_choice_content_type',
		'type'            => 'select',
		'active_callback' => 'swift_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'swift-news' ),
			'category' => esc_html__( 'Category', 'swift-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'swift_news_editor_choice_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'swift_news_editor_choice_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'swift-news' ), $i ),
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_editor_choice_content_post_' . $i,
			'active_callback' => 'swift_news_is_editor_choice_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => swift_news_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'swift_news_editor_choice_content_category',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_editor_choice_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_editor_choice_content_category',
		'active_callback' => 'swift_news_is_editor_choice_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => swift_news_get_post_cat_choices(),
	)
);

// Banner Section - Main News Horizontal Line.
$wp_customize->add_setting(
	'swift_news_editor_choice_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Swift_News_Customize_Horizontal_Line(
		$wp_customize,
		'swift_news_editor_choice_horizontal_line',
		array(
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_editor_choice_horizontal_line',
			'active_callback' => 'swift_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);

// Banner Section - Trending Topic Title.
$wp_customize->add_setting(
	'swift_news_trending_topic_title',
	array(
		'default'           => __( 'Top 5 This Week', 'swift-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'swift_news_trending_topic_title',
	array(
		'label'           => esc_html__( 'Trending Topic Title', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_trending_topic_title',
		'type'            => 'text',
		'active_callback' => 'swift_news_is_banner_section_enabled',
	)
);

// Banner Section - Trending Topic Content Type.
$wp_customize->add_setting(
	'swift_news_trending_topic_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_trending_topic_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_trending_topic_content_type',
		'type'            => 'select',
		'active_callback' => 'swift_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'swift-news' ),
			'category' => esc_html__( 'Category', 'swift-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'swift_news_trending_topic_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'swift_news_trending_topic_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'swift-news' ), $i ),
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_trending_topic_content_post_' . $i,
			'active_callback' => 'swift_news_is_trending_topic_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => swift_news_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'swift_news_trending_topic_content_category',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_trending_topic_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_trending_topic_content_category',
		'active_callback' => 'swift_news_is_trending_topic_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => swift_news_get_post_cat_choices(),
	)
);

// Banner Section - Trending Topic Horizontal Line.
$wp_customize->add_setting(
	'swift_news_trending_topic_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Swift_News_Customize_Horizontal_Line(
		$wp_customize,
		'swift_news_trending_topic_horizontal_line',
		array(
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_trending_topic_horizontal_line',
			'active_callback' => 'swift_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);

// Banner Section - Top News Title.
$wp_customize->add_setting(
	'swift_news_top_news_title',
	array(
		'default'           => __( 'Top News', 'swift-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'swift_news_top_news_title',
	array(
		'label'           => esc_html__( 'Top News Title', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_top_news_title',
		'type'            => 'text',
		'active_callback' => 'swift_news_is_banner_section_enabled',
	)
);

// Banner Section - Top News Content Type.
$wp_customize->add_setting(
	'swift_news_top_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_top_news_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_top_news_content_type',
		'type'            => 'select',
		'active_callback' => 'swift_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'swift-news' ),
			'category' => esc_html__( 'Category', 'swift-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'swift_news_top_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'swift_news_top_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'swift-news' ), $i ),
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_top_news_content_post_' . $i,
			'active_callback' => 'swift_news_is_top_news_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => swift_news_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'swift_news_top_news_content_category',
	array(
		'sanitize_callback' => 'swift_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'swift_news_top_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_top_news_content_category',
		'active_callback' => 'swift_news_is_top_news_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => swift_news_get_post_cat_choices(),
	)
);

// Banner Section - Top News Button Label.
$wp_customize->add_setting(
	'swift_news_top_news_button_label',
	array(
		'default'           => __( 'View All', 'swift-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'swift_news_top_news_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_top_news_button_label',
		'type'            => 'text',
		'active_callback' => 'swift_news_is_banner_section_enabled',
	)
);

// Banner Section - Top News Button Link.
$wp_customize->add_setting(
	'swift_news_top_news_button_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'swift_news_top_news_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'swift-news' ),
		'section'         => 'swift_news_banner_section',
		'settings'        => 'swift_news_top_news_button_link',
		'type'            => 'url',
		'active_callback' => 'swift_news_is_banner_section_enabled',
	)
);

// Banner Section - Top News Horizontal Line.
$wp_customize->add_setting(
	'swift_news_top_news_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Swift_News_Customize_Horizontal_Line(
		$wp_customize,
		'swift_news_top_news_horizontal_line',
		array(
			'section'         => 'swift_news_banner_section',
			'settings'        => 'swift_news_top_news_horizontal_line',
			'active_callback' => 'swift_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);
