<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package swallow
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="container hfeed site">
	<div class="header row">
		<header id="masthead" class="site-header col-md-12 text-center" role="banner">
		<?php if ( get_header_image() ) { ?>
			<div class="logo-swallow">  
				<a href="<?php echo esc_url(home_url()); ?>"> 
					<img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="<?php esc_attr_e( 'Logo', 'swallow' ); ?>" class="logo" />
				</a>
			</div>
		<?php } else { ?>
			<div class="site-branding">
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
			</div><!-- .site-branding -->
		<?php } ?>

		<div class="menu-toggle text-center infinity"><img src="<?php echo esc_url(get_template_directory_uri(). '/images/menu.png'); ?>" alt="menu toggle" width="70"></div>
	</header><!-- #masthead -->

	<nav id="site-navigation" class="main-navigation nav-toggle col-md-12" role="navigation">

			<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
			<?php get_search_form() ?>

	</nav><!-- #site-navigation -->

</div><!-- #header -->

<!-- the main content area which i dare to name swallow-main -->

	<section id="content" class="site-content row">
