<?php
/**
 * swallow functions and definitions
 *
 * @package swallow
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'swallow_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function swallow_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on swallow, use a find and replace
	 * to change 'swallow' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'swallow', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	//This feature enables plugins and themes to manage the document title.
	add_theme_support( 'title-tag' );


	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );
	add_theme_support( 'post-thumbnails', array( 'post', 'page' ) );
	set_post_thumbnail_size( 150, 150);
	add_image_size( 'swallow-post-image', 560, 9999 );
	
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'swallow' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array('aside', 'audio', 'image', 'link', 'quote', 'video',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'swallow_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

// Set up the WordPress core custom headers feature.

$args = array(
	'flex-width'    => true,
	'width'         => 220,
	'flex-height'    => true,
	'height'        => 136,
	'default-image' => get_template_directory_uri() . '/images/header.jpg',
);
add_theme_support( 'custom-header', $args );
	
}
endif; // swallow_setup
add_action( 'after_setup_theme', 'swallow_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function swallow_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'swallow' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'swallow_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function swallow_scripts() {
	wp_enqueue_style( 'swallow-style', get_stylesheet_uri() );
	wp_enqueue_style( 'swallow-main', get_template_directory_uri().'/css/style.css');

	wp_enqueue_script( 'swallow-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

	if( !is_admin() ) { wp_enqueue_script( 'swallow_mediaelement', get_template_directory_uri().'/js/mediaelement-and-player.js', array('jquery'), '', true  );
		}

	wp_enqueue_script( 'swallow-global', get_template_directory_uri() . '/js/global.js', array('jquery'), '', true );

	wp_enqueue_script( 'swallow-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'swallow_scripts' );

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';