<?php
/**
 *The template used for displaying links 
 *
 * @package swallow
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php swallow_posted_on(); ?>
		</div><!-- .entry-meta -->
		<div class="post-icon"> 
			<p class="icons-link"></p>
		</div><!-- #post icon -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content link">
		<?php
			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'swallow' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );
		?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'swallow' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php swallow_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->