<?php 
/**
 * The template used for displaying audio content
 *
 * @package swallow
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php swallow_posted_on(); ?>
		</div><!-- .entry-meta -->
		<div class="post-icon"> 
			<p class="icons-audio"></p>
		</div><!-- #post icon -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">

	<!-- featured media the post thumbnail -->

	<?php $audiourl = get_post_meta($post->ID, 'audiourl', true); 
	if ( $audiourl != '' ) : ?>
		

				<div class="featured-media audio">
				
					<audio controls="controls" id="audio-player">
				
						<source src="<?php echo $audiourl; ?>" />
					
					</audio>
							
				</div> <!-- /featured-media -->
					
			<?php endif; ?>

		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'swallow' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php swallow_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->