<?php
/**
 * Surrealist functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Surrealist
 * @since Surrealist 1.0
 */
declare( strict_types = 1 );

if ( ! function_exists( 'surrealist_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since Surrealist 1.0
	 *
	 * @return void
	 */
	function surrealist_support() {

		// Enqueue editor styles.
		add_editor_style( 'style.css' );

		// Make theme available for translation.
		load_theme_textdomain( 'surrealist' );
	}

endif;

add_action( 'after_setup_theme', 'surrealist_support' );

if ( ! function_exists( 'surrealist_styles' ) ) :

	/**
	 * Enqueue styles.
	 *
	 * @since Surrealist 1.0
	 *
	 * @return void
	 */
	function surrealist_styles() {

		// Register theme stylesheet.
		wp_register_style(
			'surrealist-style',
			get_stylesheet_directory_uri() . '/style.css',
			array(),
			wp_get_theme()->get( 'Version' )
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'surrealist-style' );

	}

endif;

add_action( 'wp_enqueue_scripts', 'surrealist_styles' );
