<?php
/**
 * Template part for displaying header date & time
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Suit Blog
 */

$date_enable = get_theme_mod('header_date_enable',true);
$time_enable = get_theme_mod('header_time_enable',false);

if ( $date_enable || $time_enable ) : 
?>
<div class="d-flex align-items-center site-header-item">
    <div class="d-flex align-items-center header-data-time-wrap">
        <ul class="d-flex flex-wrap justify-content-center">
            <?php if ( $date_enable ) : ?>
                <li class="d-flex align-items-center justify-content-center has-date">
                    <i class="fa fa-calendar"></i>
                    <span><?php echo wp_kses_post(date_i18n(get_option('date_format'), current_time('timestamp'))); ?></span>
                </li>
            <?php endif; ?>
            <?php if ( $time_enable ) :
                $time_format = get_theme_mod('header_time_format','en-US');
                ?>
                <li class="d-flex align-items-center justify-content-center has-time"> 
                    <i class="fa fa-clock"></i>
                    <div class="d-flex align-items-center justify-content-center">
                        <?php
                        if ($time_format == 'en-US') {
                            echo '<span class="has-time-prefix"></span>';
                            echo '<span class="has-time-suffix"></span>';
                        } else {
                            echo date_i18n(get_option('time_format'), current_time('timestamp'));
                        }
                        ?>
                    </div>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</div>
<?php
endif;
