<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Suit Blog
 */
$content_layout     = get_theme_mod('blog_posts_layout','posts-list-layout');
$content_classes    = ['entry-content-wrap'];
if ( $content_layout == 'posts-list-layout' ) {
    $content_classes[]  = 'd-md-flex p-3';
    if ( has_post_thumbnail() || get_theme_mod('blog_post_image_placeholder_enable',false) ) {
        $content_classes[]  = 'justify-content-md-center align-items-md-center';
    }
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="<?php echo esc_attr( implode(' ', $content_classes) ); ?>">
        <?php
        /**
         * Functions hooked into suit_blog_posts_entry_header action
         * 
         */
        do_action( 'suit_blog_posts_entry_header' );
        ?>

        <?php
        /**
         * Functions hooked into suit_blog_posts_entry_content action
         *
         * @hooked suit_blog_posts_content_elements - 10
         */
        do_action( 'suit_blog_posts_entry_content' );
        ?>

        <?php
        /**
         * Functions hooked into suit_blog_posts_entry_footer action
         *
         */
        do_action( 'suit_blog_posts_entry_footer' );
        ?>
    </div><!-- .entry-content-wrap -->

</article><!-- #post-<?php the_ID(); ?> -->

