<?php
/**
 * Register customizer panels and sections.
 *
 * @package Suit Blog
 */

/**
 * Panel
 */
$panels = [
    'global_panel'      => [
        'title'             => esc_html__( 'Global', 'suit-blog' ),
        'priority'          => 5
    ],
    'global_typo_panel' => [
        'title'             => esc_html__( 'Typography', 'suit-blog' ),
        'panel'             => 'global_panel',
        'priority'          => 10
    ],

    'social_panel'  => [
        'title'         => esc_html__( 'Social', 'suit-blog' ),
        'priority'      => 10
    ],

    // Header
    'header_panel'  => [
        'title'         => esc_html__( 'Header', 'suit-blog' ),
        'priority'      => 20
    ],

    // Front Page
    'front_panel'  => [
        'title'         => esc_html__( 'Front Page', 'suit-blog' ),
        'priority'      => 21
    ],

    // Blog
    'blog_panel'  => [
        'title'         => esc_html__( 'Blog', 'suit-blog' ),
        'priority'      => 25
    ],
    'blog_archive_panel'  => [
        'title'         => esc_html__( 'Blog Archives', 'suit-blog' ),
        'panel'         => 'blog_panel',
        'priority'      => 10
    ],
    'blog_single_panel'  => [
        'title'         => esc_html__( 'Single Post', 'suit-blog' ),
        'panel'         => 'blog_panel',
        'priority'      => 15
    ],
    
    // Pages
    'pages_panel'  => [
        'title'         => esc_html__( 'Pages', 'suit-blog' ),
        'priority'      => 30
    ],
    'page_panel'  => [
        'title'         => esc_html__( 'Single Page', 'suit-blog' ),
        'panel'         => 'pages_panel',
        'priority'      => 15
    ],

    // Footer
    'footer_panel'  => [
        'title'         => esc_html__( 'Footer', 'suit-blog' ),
        'priority'      => 40
    ],
];
foreach ( $panels as $panel_id => $panel_args ) {
    Kirki::add_panel( str_replace( '-', '_', $panel_id ), $panel_args );
}

/**
 * Sections
 */
$sections = [
    'base_typo_section' => [
        'panel'             => 'global_typo_panel',
        'title'             => esc_html__( 'Base', 'suit-blog' ),
        'priority'          => 5
    ],
    'heading_typo_section' => [
        'panel'             => 'global_typo_panel',
        'title'             => esc_html__( 'Heading H1 - H6', 'suit-blog' ),
        'priority'          => 10
    ],
    'widget_typo_section' => [
        'panel'             => 'global_typo_panel',
        'title'             => esc_html__( 'Widgets', 'suit-blog' ),
        'priority'          => 15
    ],
    'button_typo_section' => [
        'panel'             => 'global_typo_panel',
        'title'             => esc_html__( 'Button', 'suit-blog' ),
        'priority'          => 15
    ],
    'general_body_section'  => [
        'panel'         => 'global_panel',
        'title'         => esc_html__( 'Background Color', 'suit-blog' ),
        'priority'      => 15
    ],
    'general_container_section'  => [
        'panel'         => 'global_panel',
        'title'         => esc_html__( 'Container', 'suit-blog' ),
        'priority'      => 15
    ],
    'general_content_area_section'  => [
        'panel'         => 'global_panel',
        'title'         => esc_html__( 'Content Area', 'suit-blog' ),
        'priority'      => 15
    ],
    'general_comments_section'  => [
        'panel'         => 'global_panel',
        'title'         => esc_html__( 'Comments', 'suit-blog' ),
        'priority'      => 20
    ],
    'general_image_placeholder_section'  => [
        'panel'         => 'global_panel',
        'title'         => esc_html__( 'Image Placeholder', 'suit-blog' ),
        'priority'      => 20
    ],

    // Header
    'header_general_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'General Settings', 'suit-blog' ),
        'priority'      => 10
    ],
    'header_top_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Top Header', 'suit-blog' ),
        'priority'      => 15
    ],
    'header_main_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Main Header', 'suit-blog' ),
        'priority'      => 20
    ],
    'header_bottom_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Bottom Header', 'suit-blog' ),
        'priority'      => 25
    ],
    'header_site_identify_section'  => [
        'panel'         => 'header_panel',
        'title'         => __( 'Logo, Title & Tagline', 'suit-blog' ),
        'priority'      => 30
    ],
    'header_top_menu_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Top Menu', 'suit-blog' ),
        'priority'      => 40
    ],
    'header_menu_1_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Primary Menu', 'suit-blog' ),
        'priority'      => 40
    ],
    'header_button_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Button', 'suit-blog' ),
        'priority'      => 45
    ],
    'header_search_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Search', 'suit-blog' ),
        'priority'      => 50
    ],
    'header_search_icon_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Search Icon', 'suit-blog' ),
        'priority'      => 55
    ],
    'header_social_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'Social', 'suit-blog' ),
        'priority'      => 60
    ],
    'header_html_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'HTML', 'suit-blog' ),
        'priority'      => 65
    ],
    'header_news_ticker_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'News Ticker', 'suit-blog' ),
        'priority'      => 70
    ],
    'header_news_ticker_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'News Ticker', 'suit-blog' ),
        'priority'      => 75
    ],
    'header_date_time_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => __( 'Date & Time', 'suit-blog' ),
        'priority'      => 80
    ],
    'header_wc_cart_element_section'  => [
        'panel'         => 'header_panel',
        'title'         => esc_html__( 'WC Cart', 'suit-blog' ),
        'priority'      => 85
    ],
    // Breadcrumb
    'breadcrumb_section'  => [
        'title'         => esc_html__( 'Breadcrumb', 'suit-blog' ),
        'priority'      => 20
    ],

    // Blog
    'blog_post_top_banner_section'  => [
        'title'         => esc_html__( 'Top Banner', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_content_layout_section'  => [
        'title'         => esc_html__( 'Content Layout', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_post_title_section'  => [
        'title'         => esc_html__( 'Post Title', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_featured_image_section'  => [
        'title'         => esc_html__( 'Featured Image', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_post_excerpt_section'  => [
        'title'         => esc_html__( 'Post Excerpt', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_read_more_btn_section'  => [
        'title'         => esc_html__( 'Read More', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],
    'blog_pagination_section'  => [
        'title'         => esc_html__( 'Pagination', 'suit-blog' ),
        'panel'         => 'blog_archive_panel',
        'priority'      => 10
    ],

    // Single Post
    'single_post_top_banner_section'  => [
       'title'         => esc_html__( 'Top Banner', 'suit-blog' ),
       'panel'         => 'blog_single_panel',
       'priority'      => 10
    ],
    'single_post_content_layout_section'  => [
        'title'         => esc_html__( 'Content Layout', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    'single_post_title_section'  => [
        'title'         => esc_html__( 'Post Title', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    
    'single_post_image_section'  => [
        'title'         => esc_html__( 'Featured Image', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    'single_post_meta_section'  => [
        'title'         => esc_html__( 'Post Meta', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    'single_post_navigation_section'  => [
        'title'         => esc_html__( 'Post Navigation', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    'single_post_author_section'  => [
        'title'         => esc_html__( 'Author Box', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],
    'single_related_posts_section'  => [
        'title'         => esc_html__( 'Related Posts', 'suit-blog' ),
        'panel'         => 'blog_single_panel',
        'priority'      => 10
    ],

    // Blog -> Post Meta
    'post_meta_section'  => [
        'title'         => esc_html__( 'Post Meta', 'suit-blog' ),
        'panel'         => 'blog_panel',
        'priority'      => 10
    ],
    // Blog -> Sidebar
    'blog_sidebar_section'  => [
        'title'         => esc_html__( 'Sidebar Layout', 'suit-blog' ),
        'panel'         => 'blog_panel',
        'priority'      => 10
    ],

    // Hero Section
    'hero_section'  => [
        'title'         => esc_html__( 'Hero Section', 'suit-blog' ),
        'priority'      => 20
    ],
	
	// Box Section
    'box_section'  => [
        'title'         => esc_html__( 'FrontPage Box Section', 'suit-blog' ),
        'priority'      => 20
    ],
    
    // Pages -> Single Page
    'single_page_top_banner_section'  => [
        'title'         => esc_html__( 'Top Banner', 'suit-blog' ),
        'panel'         => 'page_panel',
        'priority'      => 10
     ],
    'single_page_content_layout_section'  => [
        'title'         => esc_html__( 'Content Layout', 'suit-blog' ),
        'panel'         => 'page_panel',
        'priority'      => 10
    ],
    'single_page_title_section'  => [
        'title'         => esc_html__( 'Page Title', 'suit-blog' ),
        'panel'         => 'page_panel',
        'priority'      => 10
    ],
    'single_page_image_section'  => [
        'title'         => esc_html__( 'Featured Image', 'suit-blog' ),
        'panel'         => 'page_panel',
        'priority'      => 10
    ],
    // Pages -> Error Page
    'error_page_top_banner_section'  => [
        'title'         => esc_html__( 'Top Banner', 'suit-blog' ),
        'panel'         => '404_panel',
        'priority'      => 10
    ],
    'error_page_content_layout_section'  => [
        'title'         => esc_html__( 'Content Layout', 'suit-blog' ),
        'panel'         => '404_panel',
        'priority'      => 10
    ],
    // Pages -> Sidebar
    'pages_sidebar_section'  => [
        'title'         => esc_html__( 'Sidebar Layout', 'suit-blog' ),
        'panel'         => 'pages_panel',
        'priority'      => 10
    ],

    // Social
    'social_network_section'  => [
        'panel'         => 'social_panel',
        'title'         => esc_html__( 'Social Network', 'suit-blog' ),
        'priority'      => 15
    ],

    // Footer
    'footer_general_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'General Settings', 'suit-blog' ),
        'priority'      => 10
    ],
    'footer_widgets_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Footer Widgets', 'suit-blog' ),
        'priority'      => 15
    ],
    'footer_top_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Top Footer', 'suit-blog' ),
        'priority'      => 15
    ],
    'footer_main_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Main Footer', 'suit-blog' ),
        'priority'      => 20
    ],
    'footer_bottom_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Bottom Footer', 'suit-blog' ),
        'priority'      => 25
    ],

    'footer_copyright_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Copyright', 'suit-blog' ),
        'priority'      => 40
    ],
    'footer_menu_1_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Footer Menu', 'suit-blog' ),
        'priority'      => 40
    ],
    'footer_button_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Button', 'suit-blog' ),
        'priority'      => 45
    ],
    'footer_social_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Social', 'suit-blog' ),
        'priority'      => 65
    ],
    'footer_html_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'HTML', 'suit-blog' ),
        'priority'      => 70
    ],
    'footer_widget_1_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Widget 1', 'suit-blog' ),
        'priority'      => 70
    ],
    'footer_widget_2_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Widget 2', 'suit-blog' ),
        'priority'      => 70
    ],
    'footer_widget_3_element_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Widget 3', 'suit-blog' ),
        'priority'      => 70
    ],
    'footer_back_to_top_section'  => [
        'panel'         => 'footer_panel',
        'title'         => esc_html__( 'Back to Top', 'suit-blog' ),
        'priority'      => 100
    ],

];


foreach ( $sections as $section_id => $section_args ) {
    Kirki::add_section( str_replace( '-', '_', $section_id ), $section_args );
}