<?php
/**
 * Add Customizer -> Single Post -> Sidebar settings.
 *
 * @package Suit Blog
 */

$fields = [
    'single_post_sidebar' => [
        'type'        => 'radio-image',
        'label'       => esc_html__( 'Sidebar Layout', 'suit-blog' ),
        'description' => esc_html__( 'Set default sidebar layout.', 'suit-blog' ),
        'section'     => 'single_post_section',
        'default'     => 'right',
        'priority'    => 10,
        'choices'     => [
            'left'      => Suit_Blog_THEME_URI . 'inc/customizer/assets/images/sidebar/left.svg',
            'right'     => Suit_Blog_THEME_URI . 'inc/customizer/assets/images/sidebar/right.svg',
            'none'      => Suit_Blog_THEME_URI . 'inc/customizer/assets/images/sidebar/none.svg'
        ],
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}