<?php
/**
 * Add Customizer -> Single Page -> Featured Image settings.
 *
 * @package Suit Blog
 */

$fields = [
    'single_page_image_placeholder_enable' => [
        'type'        => 'toggle',
        'label'       => esc_html__( 'Featured Image Placeholder', 'suit-blog' ),
        'description' => esc_html__( 'Toggle to enable/disable single page featured image placeholder if no featured image is found for post.', 'suit-blog' ),
        'section'     => 'single_page_image_section',
        'default'     => false,
        'priority'    => 10,
    ],
    'single_page_image_size' => [
        'type'              => 'select',
        'label'             => esc_html__( 'Featured Image Size', 'suit-blog' ),
        'section'           => 'single_page_image_section',
        'description'       => esc_html__( 'Set post featured image size by selecting options.', 'suit-blog' ),
        'priority'          => 15,
        'default'           => 'medium_large',
        'choices'           => [
            'thumbnail'         => esc_html__( 'Small', 'suit-blog' ),
            'medium'            => esc_html__( 'Medium', 'suit-blog' ),
            'medium_large'      => esc_html__( 'Medium Large', 'suit-blog' ),
            'large'             => esc_html__( 'Large', 'suit-blog' ),
            'full'              => esc_html__( 'Original', 'suit-blog' )
        ],
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}