<?php
/**
 * Add Customizer -> Singe Page -> Page Top Banner settings.
 *
 * @package Suit Blog
 */

$fields = [
    'single_page_top_banner_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'single_page_top_banner_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'single_page_top_banner_enable',
                    'single_page_top_banner_elements',
                    'single_page_top_banner_elements_gap',
                    'single_page_top_banner_sep_1',
                    'single_page_top_banner_background',
                    'single_page_top_banner_padding'

                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'single_page_top_banner_md_elements_gap',
                    'single_page_top_banner_sep_1',
                    'single_page_top_banner_md_padding'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'single_page_top_banner_sm_elements_gap',
                    'single_page_top_banner_sep_1',
                    'single_page_top_banner_sm_padding'
                ]
            ]
        ],
    ],
    'single_page_top_banner_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Enable', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable/disable page top banner section.', 'suit-blog' ),
        'section'           => 'single_page_top_banner_section',
        'default'           => '',
        'priority'          => 10,
    ],
    'single_page_top_banner_elements' => [
        'type'        => 'sortable',
        'label'       => esc_html__( 'Elements', 'suit-blog' ),
        'description' => esc_html__( 'Toggle to enable/disable page top banner elements and re-arrange their orders by sorting them.', 'suit-blog' ),
        'section'     => 'single_page_top_banner_section',
        'default'     => [
            'post-title',
            'breadcrumb'
        ],
        'choices'     => [
            'breadcrumb'    => esc_html__( 'Breadcrumb', 'suit-blog' ),
            'post-title'    => esc_html__( 'Post Title', 'suit-blog' ),
            'post-excerpt'  => esc_html__( 'Post Excerpt', 'suit-blog' )
        ],
        'priority'    => 10,
    ],
    'single_page_top_banner_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap between each elements of page top banner section.', 'suit-blog' ),
        'section'           => 'single_page_top_banner_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'element'   => '.page .page-top-banner header >*:not(:last-child)',
                'property'  => 'margin-bottom',
                'suffix'    => 'px'
            ],
        ],
    ],
    'single_page_top_banner_md_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap between each elements of of page top banner section only for the tablet device only.', 'suit-blog' ),
        'section'           => 'single_page_top_banner_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'element'       => '.page .page-top-banner header >*:not(:last-child)',
                'property'      => 'margin-bottom',
                'suffix'        => 'px'
            ],
        ],
    ],
    'single_page_top_banner_sm_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap between each elements of of page top banner section only for the mobile device only.', 'suit-blog' ),
        'section'           => 'single_page_top_banner_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'       => '.page .page-top-banner header >*:not(:last-child)',
                'property'      => 'margin-bottom',
                'suffix'        => 'px'
            ],
        ],
    ],
    'single_page_top_banner_sep_1' => [
        'type'              => 'custom',
        'section'           => 'single_page_top_banner_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'CONTAINER SETTING', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'single_page_top_banner_background' => [
        'type'              => 'background',
        'label'             => esc_html__( 'Background', 'suit-blog' ),
        'description'       => esc_html__( 'Set page top banner background.', 'suit-blog' ),
        'section'           => 'single_page_top_banner_section',
        'priority'          => 10,
        'default'           => [
            'background-image'      => '',
            'background-repeat'     => 'repeat',
            'background-position'   => 'center center',
            'background-size'       => 'cover',
            'background-attachment' => 'scroll',
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'element'       => '.page .page-top-banner',
            ],
        ],
    ],
    'single_page_top_banner_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set page top banner section top and bottom padding.', 'suit-blog' ),
        'section'     => 'single_page_top_banner_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '10px',
            'padding-bottom' => '10px',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'padding-top',
	            'property'  => 'padding-top',
                'element'   => '.page .page-top-banner header.page-header',
            ],
            [
                'choice'    => 'padding-bottom',
	            'property'  => 'padding-bottom',
                'element'   => '.page .page-top-banner header.page-header',
            ],
        ],
    ],
    'single_page_top_banner_md_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set page top banner section top and bottom padding.', 'suit-blog' ),
        'section'     => 'single_page_top_banner_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '10px',
            'padding-bottom' => '10px',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-top',
	            'property'      => 'padding-top',
                'element'       => '.page .page-top-banner header.page-header',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-bottom',
	            'property'      => 'padding-bottom',
                'element'       => '.page .page-top-banner header.page-header',
            ],
        ],
    ],
    'single_page_top_banner_sm_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set page top banner section top and bottom padding.', 'suit-blog' ),
        'section'     => 'single_page_top_banner_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '10px',
            'padding-bottom' => '10px',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-top',
	            'property'      => 'padding-top',
                'element'       => '.page .page-top-banner header.page-header',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-bottom',
	            'property'      => 'padding-bottom',
                'element'       => '.page .page-top-banner header.page-header',
            ],
        ],
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}