<?php
/**
 * Add Customizer -> Footer -> Footer Rows -> Bottom Row settings.
 *
 * @package Suit Blog
 */

$fields = array(
	'footer_bottom_group_fields'       => array(
		'type'     => 'group-field',
		'section'  => 'footer_bottom_section',
		'priority' => 5,
		'tabs'     => array(
			'desktop' => array(
				'nicename'   => esc_html__( '&gt; 1200px', 'suit-blog' ),
				'preview'    => 'desktop',
				'active_tab' => true,
				'controls'   => array(
					'footer_bottom_left_elements',
					'footer_bottom_center_elements',
					'footer_bottom_right_elements',
					'footer_bottom_background',
					'footer_bottom_section_padding',
				),
			),
			'tablet'  => array(
				'nicename'   => esc_html__( '&gt; 768px', 'suit-blog' ),
				'preview'    => 'tablet',
				'active_tab' => false,
				'controls'   => array(
					'footer_bottom_section_md_padding',
				),
			),
			'mobile'  => array(
				'nicename'   => esc_html__( '&lt; 576px', 'suit-blog' ),
				'preview'    => 'mobile',
				'active_tab' => false,
				'controls'   => array(
					'footer_bottom_section_sm_padding',
				),
			),
		),
	),
	'footer_bottom_left_elements'      => array(
		'type'                => 'repeater',
		'label'               => esc_html__( 'Left Elements', 'suit-blog' ),
		'description'         => esc_html__( 'Click button to add new elements on lef column of bottom footer section and re-arrange element orders by sorting them.', 'suit-blog' ),
		'section'             => 'footer_bottom_section',
		'row_label'           => array(
			'type'  => 'field',
			'value' => esc_html__( 'Element', 'suit-blog' ),
			'field' => 'element_id',
		),
		'footer_bottom_label' => esc_html__( 'Add Element', 'suit-blog' ),
		'fields'              => array(
			'element_id' => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Selected Element', 'suit-blog' ),
				'default' => 'none',
				'choices' => array(
					'none'      => esc_html__( 'None', 'suit-blog' ),
					'copyright' => esc_html__( 'Copyright', 'suit-blog' ),
					'menu_1'    => esc_html__( 'Footer Menu', 'suit-blog' ),
					'social'    => esc_html__( 'Social', 'suit-blog' ),
					'button'    => esc_html__( 'Button', 'suit-blog' ),
					'html_1'    => esc_html__( 'HTML', 'suit-blog' ),
					'widget_1'  => esc_html__( 'Widget 1', 'suit-blog' ),
					'widget_2'  => esc_html__( 'Widget 2', 'suit-blog' ),
					'widget_3'  => esc_html__( 'Widget 3', 'suit-blog' ),
				),
			),
		),
		'choices' 			=> [
			'limit' 		=> 3
		],
		'priority'            => 10,
	),
	'footer_bottom_center_elements'    => array(
		'type'                => 'repeater',
		'label'               => esc_html__( 'Center Elements', 'suit-blog' ),
		'description'         => esc_html__( 'Click button to add new elements on center column of bottom footer section and re-arrange element orders by sorting them.', 'suit-blog' ),
		'section'             => 'footer_bottom_section',
		'row_label'           => array(
			'type'  => 'field',
			'value' => esc_html__( 'Element', 'suit-blog' ),
			'field' => 'element_id',
		),
		'footer_bottom_label' => esc_html__( 'Add Element', 'suit-blog' ),
		'fields'              => array(
			'element_id' => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Selected Element', 'suit-blog' ),
				'default' => 'none',
				'choices' => array(
					'none'      => esc_html__( 'None', 'suit-blog' ),
					'copyright' => esc_html__( 'Copyright', 'suit-blog' ),
					'menu_1'    => esc_html__( 'Footer Menu', 'suit-blog' ),
					'social'    => esc_html__( 'Social', 'suit-blog' ),
					'button'    => esc_html__( 'Button', 'suit-blog' ),
					'html_1'    => esc_html__( 'HTML', 'suit-blog' ),
					'widget_1'  => esc_html__( 'Widget 1', 'suit-blog' ),
					'widget_2'  => esc_html__( 'Widget 2', 'suit-blog' ),
					'widget_3'  => esc_html__( 'Widget 3', 'suit-blog' ),
				),
			),
		),
		'choices' 			=> [
			'limit' 		=> 3
		],
		'priority'            => 10,
	),
	'footer_bottom_right_elements'     => array(
		'type'                => 'repeater',
		'label'               => esc_html__( 'Right Elements', 'suit-blog' ),
		'description'         => esc_html__( 'Click button to add new elements on right column of bottom footer section and re-arrange element orders by sorting them.', 'suit-blog' ),
		'section'             => 'footer_bottom_section',
		'row_label'           => array(
			'type'  => 'field',
			'value' => esc_html__( 'Element', 'suit-blog' ),
			'field' => 'element_id',
		),
		'footer_bottom_label' => esc_html__( 'Add Element', 'suit-blog' ),
		'fields'              => array(
			'element_id' => array(
				'type'    => 'select',
				'label'   => esc_html__( 'Selected Element', 'suit-blog' ),
				'default' => 'none',
				'choices' => array(
					'none'      => esc_html__( 'None', 'suit-blog' ),
					'copyright' => esc_html__( 'Copyright', 'suit-blog' ),
					'menu_1'    => esc_html__( 'Footer Menu', 'suit-blog' ),
					'social'    => esc_html__( 'Social', 'suit-blog' ),
					'button'    => esc_html__( 'Button', 'suit-blog' ),
					'html_1'    => esc_html__( 'HTML', 'suit-blog' ),
					'widget_1'  => esc_html__( 'Widget 1', 'suit-blog' ),
					'widget_2'  => esc_html__( 'Widget 2', 'suit-blog' ),
					'widget_3'  => esc_html__( 'Widget 3', 'suit-blog' ),
				),
			),
		),
		'choices' 			=> [
			'limit' 		=> 3
		],
		'priority'            => 10,
	),
	'footer_bottom_background'         => array(
		'type'      => 'background',
		'section'   => 'footer_bottom_section',
		'priority'  => 15,
		'default'   => array(
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'transport' => 'auto',
		'output'    => array(
			array(
				'element' => '.site-footer .site-footer-bottom-row',
			),
		),
	),
	'footer_bottom_section_padding'    => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer top section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_bottom_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'choice'   => 'padding-top',
				'property' => 'padding-top',
				'element'  => '.site-footer .site-footer-bottom-row',
			),
			array(
				'choice'   => 'padding-bottom',
				'property' => 'padding-bottom',
				'element'  => '.site-footer .site-footer-bottom-row',
			),
		),
	),
	'footer_bottom_section_md_padding' => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer top section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_bottom_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'media_query' => '@media (max-width: 768px)',
				'choice'      => 'padding-top',
				'property'    => 'padding-top',
				'element'     => '.site-footer .site-footer-bottom-row',
			),
			array(
				'media_query' => '@media (max-width: 768px)',
				'choice'      => 'padding-bottom',
				'property'    => 'padding-bottom',
				'element'     => '.site-footer .site-footer-bottom-row',
			),
		),
	),
	'footer_bottom_section_sm_padding' => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer top section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_bottom_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'media_query' => '@media (max-width: 576px)',
				'choice'      => 'padding-top',
				'property'    => 'padding-top',
				'element'     => '.site-footer .site-footer-bottom-row',
			),
			array(
				'media_query' => '@media (max-width: 576px)',
				'choice'      => 'padding-bottom',
				'property'    => 'padding-bottom',
				'element'     => '.site-footer .site-footer-bottom-row',
			),
		),
	),

);
foreach ( $fields as $field_id => $field_args ) {
	// Settings
	$field_args['settings'] = str_replace( '-', '_', $field_id );

	Kirki::add_field( 'suit-blog', $field_args );
}
