<?php
/**
 * Add Customizer -> Blog Posts -> Content settings.
 *
 * @package Suit Blog
 */

$fields = [
    'blog_content_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'blog_content_layout_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'blog_posts_layout',
                    'blog_posts_grid_cols',
                    'blog_post_content_elements',
                    'blog_post_content_elements_gap'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'blog_post_content_md_elements_gap'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'blog_post_content_sm_elements_gap'
                ]
            ]
        ],
    ],
    'blog_posts_layout' => [
        'type'              => 'radio',
        'label'             => esc_html__( 'Layout As', 'suit-blog' ),
        'section'           => 'blog_content_layout_section',
        'default'           => 'posts-list-layout',
        'priority'          => 10,
        'choices'           => [
            'posts-grid-layout' => esc_html__( 'Grid', 'suit-blog' ),
            'posts-list-layout' => esc_html__( 'List', 'suit-blog' )
        ],
    ],
    'blog_posts_grid_cols' => [
        'type'              => 'select',
        'label'             => esc_html__( 'Number Of Columns', 'suit-blog' ),
        'section'           => 'blog_content_layout_section',
        'default'           => '2',
        'choices'           => [
            '2'             => '2',
            '3'             => '3',
            '4'             => '4'
        ],
        'priority'          => 10,
    ],
    'blog_post_content_elements' => [
        'type'        => 'sortable',
        'label'       => esc_html__( 'Elements', 'suit-blog' ),
        'description' => esc_html__( 'Toggle to enable/disable blog post content elements and re-arrange their orders by sorting them.', 'suit-blog' ),
        'section'     => 'blog_content_layout_section',
        'default'     => [
            'post-image',
            'post-cats',
            'post-title',
            'post-meta',
            'post-excerpt'
        ],
        'choices'     => [
            'post-image'    => esc_html__( 'Featured Image', 'suit-blog' ),
            'post-title'    => esc_html__( 'Post Title', 'suit-blog' ),
            'post-meta'     => esc_html__( 'Post Meta', 'suit-blog' ),
            'post-excerpt'  => esc_html__( 'Post Excerpt', 'suit-blog' ),
            'read-more'     => esc_html__( 'Read More', 'suit-blog' ),
            'post-cats'     => esc_html__( 'Categories', 'suit-blog' ),
            'post-tags'     => esc_html__( 'Tags', 'suit-blog' ),
            
        ],
        'priority'    => 10,
    ],
    'blog_post_content_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap in PX between each elements of blog post for the current device only.', 'suit-blog' ),
        'section'           => 'blog_content_layout_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'element'   => '.suit-blog-blog .section-post-container .entry-content-wrap .content-element > *:not(:last-child),.archive-posts.posts-grid-layout .entry-content-wrap .has-posts-thumb',
                'property'  => 'margin-bottom',
                'suffix'    => 'px'
            ],
            [
                'element'   => '.archive-posts.posts-grid-layout .entry-content-wrap >*:not(:first-child)',
                'property'  => 'margin-top',
                'suffix'    => 'px'
            ],
        ],
    ],
    'blog_post_content_md_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap in PX between each elements of blog post for the current device only.', 'suit-blog' ),
        'section'           => 'blog_content_layout_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'element'   => '.suit-blog-blog .section-post-container .entry-content-wrap .content-element > *:not(:last-child),.archive-posts.posts-grid-layout .entry-content-wrap .has-posts-thumb',
                'property'  => 'margin-bottom',
                'suffix'    => 'px'
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'element'   => '.archive-posts.posts-grid-layout .entry-content-wrap >*:not(:first-child)',
                'property'  => 'margin-top',
                'suffix'    => 'px'
            ],
        ],
    ],
    'blog_post_content_sm_elements_gap' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Elements Gap', 'suit-blog' ),
        'description'       => esc_html__( 'Set gap in PX between each elements of blog post for the current device only.', 'suit-blog' ),
        'section'           => 'blog_content_layout_section',
        'default'           => 15,
        'choices'           => [
            'min'               => 0,
            'max'               => 100,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'   => '.suit-blog-blog .section-post-container .entry-content-wrap .content-element > *:not(:last-child),.archive-posts.posts-grid-layout .entry-content-wrap .has-posts-thumb',
                'property'  => 'margin-bottom',
                'suffix'    => 'px'
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'   => '.archive-posts.posts-grid-layout .entry-content-wrap >*:not(:first-child)',
                'property'  => 'margin-top',
                'suffix'    => 'px'
            ],
        ],
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}