<?php
/**
 * Suit Customizer Class
 *
 * @package Suit Blog
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * suit_blog_Customizer class
 */
class suit_blog_Customizer {

    /**
     * Setup class.
     *
     */
    public function __construct() {

        add_action( 'customize_register', [ $this, 'suit_blog_customize_register' ] );

        add_action( 'customize_register', [ $this, 'suit_blog_customize_helpers' ] );

        add_action( 'customize_preview_init', [ $this, 'suit_blog_customize_preview_js' ] );

        add_action( 'customize_controls_enqueue_scripts', [ $this, 'suit_blog_customize_js' ] );
    }


    /**
     * Include customizer helpers.
     */
    public function suit_blog_customize_helpers() {
        require Suit_Blog_THEME_DIR . 'inc/customizer/class-suit-blog-customizer-partials.php';
    }

    /**
     * Add postMessage support for site title and description for the Theme Customizer.
     *
     * @param WP_Customize_Manager $wp_customize Theme Customizer object.
     */
    public function suit_blog_customize_register( $wp_customize ) {

        $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
        $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

        $wp_customize->remove_control('header_textcolor');

        if ( isset( $wp_customize->selective_refresh ) ) {
            $wp_customize->selective_refresh->add_partial(
                'blogname',
                array(
                    'selector'        => '.site-title a',
                    'render_callback' => [ $this, 'suit_blog_customize_partial_blogname' ],
                )
            );
            $wp_customize->selective_refresh->add_partial(
                'blogdescription',
                array(
                    'selector'        => '.site-description',
                    'render_callback' => [ $this, 'suit_blog_customize_partial_blogdescription' ],
                )
            );
        }
    }

    /**
     * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
     */
    public function suit_blog_customize_preview_js() {

        wp_enqueue_script( 'suit-blog-customizer-preview', Suit_Blog_THEME_URI . 'inc/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), Suit_Blog_THEME_VERSION, true );
    }

    /**
     * heme Customizer JS
     */
    public function suit_blog_customize_js() {

        // Enqueue the style.
        wp_enqueue_style( 'suit-blog-customize-controls', Suit_Blog_THEME_URI . 'inc/customizer/assets/css/customize-controls.css', null, Suit_Blog_THEME_VERSION, 'all' );

        // Add output of Customizer settings as inline style.
        wp_add_inline_style( 'suit-blog-customize-controls', suit_blog_Customizer_Inline_Style::css_output( 'customizer' ) );

        wp_enqueue_script( 'suit-blog-customizer', Suit_Blog_THEME_URI . 'inc/customizer/assets/js/customizer.js', array( 'jquery', 'customize-controls' ), Suit_Blog_THEME_VERSION, false );
    }
}

new suit_blog_Customizer();