<?php
/**
 * This file adds a custom section in the customizer that recommends the installation of the Kirki plugin.
 * It can be used as-is in themes (drop-in).
 *
 * @package Suit Blog
 */

if ( ! function_exists( 'suit_blog_kirki_installer_register' ) ) {
	/**
	 * Registers the section, setting & control for the Kirki installer.
	 *
	 * @param object $wp_customize The main customizer object.
	 */

	function suit_blog_kirki_installer_register( $wp_customize ) {

		// Early exit if Kirki exists.
		if ( suit_blog_kirki_plugin() ) {
			// Header Image
			$wp_customize->get_section( 'colors' )->panel    = 'global_panel';
			$wp_customize->get_section( 'colors' )->priority = 10;
		}

		if ( class_exists( 'WP_Customize_Section' ) && ! class_exists( 'Kirki_Installer_Section' ) ) {

			/**
			 * Recommend the installation of Kirki using a custom section.
			 *
			 * @see WP_Customize_Section
			 */

			class Kirki_Installer_Section extends WP_Customize_Section {

				/**
				 * Customize section type.
				 *
				 * @access public
				 * @var string
				 */

				public $type = 'kirki_installer';

				/**
				 * The plugin install URL.
				 *
				 * @access private
				 * @var string
				 */

				public $plugin_install_url;

				/**
				 * Render the section.
				 *
				 * @access protected
				 */
				protected function render() {

					if ( suit_blog_kirki_plugin() ) {
						?>
						<!-- Upgrade to PRO -->
						<li id="accordion-section-upgrade-pro" class="cannot-expand accordion-section control-section control-section-themes accordion-section-pro" style="border-top:none;border-bottom:1px solid #ddd;padding:7px 14px 16px 14px;text-align:right;">
							<?php $this->upgrade_button(); ?>
						</li>
						
						<?php
					} else {
						// Don't proceed any further if the user has dismissed this.
						if ( $this->is_dismissed() ) {
							return;
						}

						// Determine if the plugin is not installed, or just inactive.
						$plugins   = get_plugins();
						$installed = false;
						foreach ( $plugins as $plugin ) {
							if ( 'Kirki' === $plugin['Name'] || 'Kirki Toolkit' === $plugin['Name'] || 'Kirki Customizer Framework' === $plugin['Name'] ) {
								$installed = true;
							}
						}
						$plugin_install_url = $this->get_plugin_install_url();
						$classes            = 'cannot-expand accordion-section control-section control-section-themes control-section-' . $this->type;
						?>
						<li id="accordion-section-<?php echo esc_attr( $this->id ); ?>" class="<?php echo esc_attr( $classes ); ?>" style="border-top:none;border-bottom:1px solid #ddd;padding:7px 14px 16px 14px;text-align:right;">
							<?php if ( ! $installed ) : ?>
								<?php $this->install_button(); ?>
							<?php else : ?>
								<?php $this->activate_button(); ?>
							<?php endif; ?>
							<?php $this->dismiss_button(); ?>
						</li>
						<?php
					}
				}

				/**
				 * Check if the user has chosen to hide this.
				 *
				 * @static
				 * @access public
				 * @since 1.0.0
				 * @return bool
				 */

				public static function is_dismissed() {
					// Get the user-meta.
					$user_id   = get_current_user_id();
					$user_meta = get_user_meta( $user_id, 'dismiss-kirki-recommendation', true );
					return ( true === $user_meta || '1' === $user_meta || 1 === $user_meta );

				}

				/**
				 * Adds the install button.
				 *
				 * @since 1.0.0
				 * @return void
				 */

				protected function install_button() {
					?>
					<p style="text-align:left;margin-top:0;">
						<?php esc_html_e( 'Please install the Kirki plugin to take full advantage of this theme\'s customizer capabilities', 'suit-blog' ); ?>
					</p>
					<a class="install-now button-primary button" data-slug="kirki" href="<?php echo esc_url_raw( $this->get_plugin_install_url() ); ?>" aria-label="<?php esc_attr_e( 'Install Kirki Toolkit now', 'suit-blog' ); ?>" data-name="Kirki Toolkit">
						<?php esc_html_e( 'Install Now', 'suit-blog' ); ?>
					</a>
					<?php

				}

				/**
				 * Adds the install button.
				 *
				 * @since 1.0.0
				 * @return void
				 */

				protected function activate_button() {
					?>
					<p style="text-align:left;margin-top:0;">
						<?php esc_html_e( 'You have installed Kirki. Activate it to take advantage of this theme\'s features in the customizer.', 'suit-blog' ); ?>
					</p>

					<a class="activate-now button-primary button" data-slug="kirki" href="<?php echo esc_url_raw( self_admin_url( 'plugins.php' ) ); ?>" aria-label="<?php esc_attr_e( 'Activate Kirki Toolkit now', 'suit-blog' ); ?>" data-name="Kirki Toolkit">
						<?php esc_html_e( 'Activate Now', 'suit-blog' ); ?>
					</a>
					<?php
				}

				protected function upgrade_button() {
					?>
					
					<h5 style="text-align:left;margin-top:0;">
						<?php esc_html_e( 'Upgrade to PRO', 'suit-blog' ); ?>
						<a class="activate-now button-primary button button-pro" data-slug="kirki" href="https://excelthemes.com/suit-blog-pro/" aria-label="<?php esc_attr_e( 'Upgrade to pro', 'suit-blog' ); ?>" data-name="Kirki Toolkit" target="_blank">
							<?php esc_html_e( 'Click', 'suit-blog' ); ?>
						</a>
					</h5>
					<?php
				}

				/**
				 * Adds the dismiss button and script.
				 *
				 * @since 1.0.0
				 * @return void
				 */

				protected function dismiss_button() {
					// Create the nonce.
					$ajax_nonce = wp_create_nonce( 'dismiss-kirki-recommendation' );
					// Show confirmation dialog on dismiss?
					$show_confirm = true;
					?>

					<a class="kirki-installer-dismiss button-secondary button" data-slug="kirki" href="#" aria-label="<?php esc_attr_e( 'Don\'t show this again', 'suit-blog' ); ?>" data-name="<?php esc_attr_e( 'Dismiss', 'suit-blog' ); ?>">
						<?php esc_html_e( 'Don\'t show this again', 'suit-blog' ); ?>
					</a>
					<script type="text/javascript">
						jQuery( document ).ready( function() {
							jQuery( '.kirki-installer-dismiss' ).on( 'click', function( event ) {
								event.preventDefault();

								<?php if ( $show_confirm ) : ?>
								if ( ! confirm( '<?php esc_html_e( 'Are you sure? Dismissing this message will hide the installation recommendation and you will have to manually install and activate the plugin in the future.', 'suit-blog' ); ?>' ) ) {
									return;
								}
								<?php endif; ?>

								jQuery.post( ajaxurl, {
									action: 'suit_blog_kirki_installer_dismiss',
									security: '<?php echo esc_html( $ajax_nonce ); ?>',
								}, function( response ) {
									jQuery( '#accordion-section-kirki_installer' ).remove();
								} );
							} );
						} );

					</script>
					<?php
				}

				/**

				 * Get the plugin install URL.
				 *
				 * @access private
				 * @return string
				 */

				private function get_plugin_install_url() {
					if ( ! $this->plugin_install_url ) {

						// Get the plugin-installation URL.
						$this->plugin_install_url = add_query_arg(
							array(
								'action' => 'install-plugin',
								'plugin' => 'kirki',
							),
							self_admin_url( 'update.php' )
						);
						$this->plugin_install_url = wp_nonce_url( $this->plugin_install_url, 'install-plugin_kirki' );
					}
					return $this->plugin_install_url;
				}
			}
		}

		// Early exit if the user has dismissed the notice.
		if ( is_callable( array( 'Kirki_Installer_Section', 'is_dismissed' ) ) && Kirki_Installer_Section::is_dismissed() ) {
			return;
		}

		$wp_customize->add_section(
			new Kirki_Installer_Section(
				$wp_customize,
				'kirki_installer',
				array(
					'title'      => '',
					'capability' => 'install_plugins',
					'priority'   => 0,
				)
			)
		);

		$wp_customize->add_setting(
			'kirki_installer_setting',
			array(
				'sanitize_callback' => '__return_true',
			)
		);

		$wp_customize->add_control(
			'kirki_installer_control',
			array(
				'section'  => 'kirki_installer',
				'settings' => 'kirki_installer_setting',
			)
		);
	}
}

add_action( 'customize_register', 'suit_blog_kirki_installer_register', 999 );

if ( ! function_exists( 'suit_blog_kirki_installer_dismiss' ) ) {

	/**
	 * Handles dismissing the plugin-install/activate recommendation.
	 * If the user clicks the "Don't show this again" button, save as user-meta.
	 *
	 * @since 1.0.0
	 * @return void
	 */

	function suit_blog_kirki_installer_dismiss() {
		check_ajax_referer( 'dismiss-kirki-recommendation', 'security' );
		$user_id = get_current_user_id();
		if ( update_user_meta( $user_id, 'dismiss-kirki-recommendation', true ) ) {
			echo 'success! :-)';
			wp_die();
		}
		echo 'failed :-(';
		wp_die();
	}
}
add_action( 'wp_ajax_kirki_installer_dismiss', 'suit_blog_kirki_installer_dismiss' );

/**
 * Registers the control with Kirki.
 *
 * @since 1.0
 * @param array $controls An array of controls registered with the Kirki Toolkit.
 * @return array
 */

add_filter(
	'kirki_control_types',
	function( $controls ) {

		// Register Custom Control -> Group Fields
		require Suit_Blog_THEME_DIR . 'inc/customizer/controls/group-field/Suit_Blog_Customize_Group_Field_Control.php';
		$controls['group-field'] = 'Suit_Blog_Customize_Group_Field_Control';
		return $controls;
	}
);



/**
 * Include customizer options.
 */

add_action(
	'init',
	function() {

		// Early exit if Kirki exists.
		if ( suit_blog_kirki_plugin() ) {
			Kirki::add_config(
				'suit-blog',
				array(
					'capability'  => 'edit_theme_options',
					'option_type' => 'theme_mod',
				)
			);

			// Panels and Sections
			require Suit_Blog_THEME_DIR . 'inc/customizer/register-panels-and-sections.php';
			// Global -> Typography
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/global/typo.php';
			// Global -> Colors
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/global/colors.php';
			// Global -> Container
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/global/container.php';
			// Global -> Comments
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/global/comments.php';
			// Global -> Image Placeholder
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/global/image-placeholder.php';

			// Header -> Rows -> Fields
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/rows/fields.php';
			// Header -> Rows -> Top Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/rows/top-fields.php';
			// Header -> Rows -> Middle Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/rows/main-fields.php';
			// Header -> Rows -> Bottom Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/rows/bottom-fields.php';
			// Header -> Button Element -> Bottom
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/button.php';
			// Header -> Search Element -> Search
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/normal-search.php';
			// Header -> Social Element -> Social
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/social.php';
			// Header -> Menu 2 Element -> Top Menu
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/top-menu.php';
			// Header -> Menu 1 Element -> Menu 1
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/menu-1.php';
			// Header -> Site identity Element -> Site identity
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/site-identity.php';
			// Header -> HTML 1 Element -> HTML 1
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/html-1.php';
			// Header -> News ticker Element -> News Ticker
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/news-ticker.php';
			// Header -> Date Time Element -> Date Time
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/date-time.php';
			// Header -> WC Cart Element -> Cart
			if ( class_exists( 'WooCommerce' ) ) {
				require Suit_Blog_THEME_DIR . 'inc/customizer/options/header/elements/cart.php';
			}
			
			// Hero Section
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/hero/settings.php';
			
			// Box Section
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/box/settings.php';

			/**
			 * Blog Nested Panel,section and settings
			 */
			// Blog -> Blog Archives -> Page Header
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/blog-top-banner.php';
			// Blog -> Blog Archives -> Content Layout
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/content-layout.php';
			// Blog -> Blog Archives -> Featured Image
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/featured-image.php';
			// Blog -> Blog Archives -> Post Title
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/post-title.php';
			// Blog -> Blog Archives -> Post Excerpt
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/post-excerpt.php';
			// Blog -> Blog Archives -> Read More
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/read-more.php';
			// Blog -> Blog Archives -> Pagination
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/blog-archives/pagination.php';

			// Blog -> Single Post -> Page Title
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/post-top-banner.php';
			// Blog -> Single Post -> Content Layout
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/content-layout.php';
			// Blog -> Single Post -> Featured Image
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/post-title.php';
			// Blog -> Single Post -> Featured Image
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/featured-image.php';
			// Blog -> Single Post -> Post Navigation
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/post-navigation.php';
			// Blog -> Single Post -> Author Box
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/author.php';
			// Blog -> Single Post -> Related Posts
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/single-post/related-posts.php';
			// Blog -> Sidebar
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/sidebar.php';
			// Blog -> Post Meta
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/blog/post-meta.php';

			/**
			 * Pages Nested Panel
			 */
			// Pages -> Single Page -> Page Top Banner
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/pages/single/banner.php';
			// Pages -> Single Page -> Content
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/pages/single/content-layout.php';
			// Pages -> Single Page -> Featured Image
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/pages/single/featured-image.php';
			// Pages -> Single Page -> Page Title
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/pages/single/title.php';

			// Pages -> Sidebar
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/pages/sidebar.php';

			// Social -> Social Networks
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/social/social-networks.php';

			// Footer -> Rows -> Fields
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/rows/fields.php';
			// Footer -> Rows -> Footer Widgets
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/rows/footer-widgets.php';
			// Footer -> Rows -> Top Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/rows/top-fields.php';
			// Footer -> Rows -> Middle Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/rows/main-fields.php';
			// Footer -> Rows -> Bottom Row
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/rows/bottom-fields.php';
			// Footer -> Button Element -> Bottom
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/button.php';
			// Footer -> Social Element -> Social
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/social.php';
			// Footer -> Menu 1 Element -> Menu 1
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/menu-1.php';
			// Footer -> HTML Element -> HTML
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/html.php';
			// Footer -> Element -> Copyright
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/copyright.php';
			// Footer -> Element -> Widget 1
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/widget-1.php';
			// Footer -> Element -> Widget 2
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/widget-2.php';
			// Footer -> Element -> Widget 3
			require Suit_Blog_THEME_DIR . 'inc/customizer/options/footer/elements/widget-3.php';
			// Footer -> Element -> Widget 4
		}
	},
	999
);

