<?php

/**
 * Template part for displaying front-page featured slider section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Suit Blog
 */

 $enable = false;
 if ( ( is_front_page() || is_home() )  && get_theme_mod('hero_home_page_enable', true) ) {
	$enable = true;
 }
 elseif ( is_page() && get_theme_mod('hero_single_pages_enable', false) ) {
	$enable = true;
 }
 elseif ( is_single() && get_theme_mod('hero_single_posts_enable', false) ) {
	$enable = true;
 }

global $post;
$banner_id = get_theme_mod(
	'hero_banner_id',
	''
);

// Arguments
$args = [
	'post_type'             => 'post',
	'posts_per_page'        => '1',
	'no_found_rows'         => true,
	'ignore_sticky_posts'   => true
];

if ( $banner_id ) {
	$args['p'] = absint($banner_id);
}

$the_query = new WP_Query( $args );

if ( $the_query->have_posts() && $enable ) : ?>
	<section class="hero-section">
		<div class="hero-conatiner d-flex justify-content-center">
			<?php while ( $the_query->have_posts() ) : $the_query->the_post();
			$img_url = has_post_thumbnail() 
					? get_the_post_thumbnail_url(get_the_ID(),'full') 
					: get_theme_mod( 'image_placeholder_image', '' );
			?>
				<div class="hero-content-wrapper position-relative" style="background-image:url(<?php echo esc_url( $img_url ); ?>);">
					<div class="container position-relative z-index">
						<div class="hero-content-details col-12 col-lg-8">

							<div class="hero-cats-tags">
								<span class="hero-area__cats">
									<?php the_category( ', ' ); ?>
								</span>
								<span class="hero-area_tags">
									<?php the_tags( '', ' ', '' ); ?>
								</span>
							</div>

								<?php the_title( '<h2 class="hero-title headline section--hero__row__title-area__headline">','</h2>' ); ?>

								<?php
								suit_blog_the_post_meta( get_the_ID(),'hero-post-meta', ['post-date', 'post-author'] );
								?>
						</div>
					</div>
				</div>
				<?php wp_reset_postdata(); ?>
			<?php endwhile; ?>
		</div><!-- .hero-wrapper -->
	</section><!-- .hero-section -->
	
<?php endif;
