<?php
/**
 * Template part for displaying header featured
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Suit Blog
 */
global $post;
$featured_cats = get_theme_mod(
	'header_news_ticker_cat_id'
);
$posts_limit = get_theme_mod(
	'header_news_ticker_limit',
	10
);
$terms = get_terms( array('taxonomy' => 'category') );

// Arguments
$args = [
	'post_type'             => 'post',
	'posts_per_page'        => absint($posts_limit),
	'no_found_rows'         => true,
	'ignore_sticky_posts'   => true
];

if ( $featured_cats && !empty( $terms ) && in_array( $featured_cats, wp_list_pluck( $terms, 'term_id' ) ) ) {
	
	$args['category__in'] = absint($featured_cats);
}

$the_query = new WP_Query( $args );

if ( $the_query->have_posts() ) :
    $newsup_ticker_news_title = get_theme_mod( 'header_news_ticker_heading', esc_html__( 'Breaking News', 'suit-blog' ) );
    ?>
    <div class="d-flex align-items-center site-header-item header-news-wrap">
       <?php if ( get_theme_mod('header_news_ticker_heading_enable') && !empty($newsup_ticker_news_title)): ?>
            <div class="bn_title">
                <h2>
                    <?php echo esc_html($newsup_ticker_news_title); ?>
                </h2>
            </div>
        <?php endif; ?>

        <div class="header-news-wrap-slider marquee<?php if ( get_theme_mod('header_news_ticker_heading_enable') ) { echo ' enable-heading';} ?>">
            <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                    
                    <a href="<?php echo esc_url( get_the_permalink() ); ?>">
                        <i class="fa fa-circle"></i>
                        <span><?php echo get_the_title(); ?></span>
                    </a>
                   
                <?php wp_reset_postdata(); ?>
			<?php endwhile; ?>
        </div>
    </div>
<?php endif;
