<?php
/**
 * Template part for displaying footer Copyright content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Suit Blog
 */

$copyright      = get_theme_mod('footer_copyright_content',__( 'Copyright {copyright} {current_year} {site_title}', 'suit-blog' ));
$copyright      = str_replace( '{copyright}', '&copy;', $copyright );
$copyright      = str_replace( '{current_year}', date_i18n( _x( 'Y', 'copyright date format; check date() on php.net', 'suit-blog' ) ), $copyright );
$copyright      = str_replace( '{site_title}', get_bloginfo( 'name' ), $copyright );
$copyright      .= sprintf(
/* translators: 1: title. */
	esc_html__( ' - Powered by %1$s', 'suit-blog' ),
	'<a href="'.esc_url('https://www.excelthemes.com/').'" rel="nofollow noopener" target="_self">' . esc_html__('Excel Themes', 'suit-blog') . '</a>'
);
?>
<div class="d-flex align-items-center site-footer-item">
    <div class="site-coptyright-item site-footer-item">
        <div class="footer-copyright-inner"><?php echo wp_kses_post( do_shortcode( $copyright ) ); ?></div>
    </div>
</div>
