<?php
/**
 * Suit hooks
 *
 * @package Suit Blog
 */

/* ------------------------------ HEADER ------------------------------ */
/**
 * Meta head.
 *
 * @see suit_blog_head_meta()
 */
add_action( 'suit_blog_head', 'suit_blog_head_meta', 10 );

/**
 * Header main to display site branding and navigation.
 *
 * @see suit_blog_header_main()
 */
add_action( 'suit_blog_header', 'suit_blog_header_main', 10 );


/**
 * Site Content Wrapper Start
 *
 * @see suit_blog_hero_section()
 * @see suit_blog_box_section()
 * @see suit_blog_site_content_start()
 */
add_action( 'suit_blog_header_after', 'suit_blog_hero_section', 5 );
add_action( 'suit_blog_header_after', 'suit_blog_box_section', 8 );
add_action( 'suit_blog_header_after', 'suit_blog_site_content_start', 10 );



/* ------------------------------ CONTENT ------------------------------ */

/**
 * Primary Content Wrapper Start
 *
 * @see suit_blog_site_primary_content_start()
 */
add_action( 'suit_blog_content_before', 'suit_blog_site_page_head', 5 );
add_action( 'suit_blog_content_before', 'suit_blog_site_primary_content_start', 10 );

/**
 * Primary Content Wrapper Start
 *
 * @see suit_blog_site_content_sidebar()
 * @see suit_blog_site_primary_content_end()
 */
add_action( 'suit_blog_content_after', 'suit_blog_site_content_sidebar', 10 );
add_action( 'suit_blog_content_after', 'suit_blog_site_primary_content_end', 15 );

/* ------------------------------ BLOG/ARCHIVE PAGE ------------------------------ */
/**
 * Before Posts Content
 *
 * @see suit_blog_posts_cols_per_row_start()
 */
add_action( 'suit_blog_posts_content_loop_before', 'suit_blog_posts_cols_per_row_start', 10 );

/**
 * After Posts Content
 *
 * @see suit_blog_posts_cols_per_row_close()
 * @see suit_blog_posts_navigation()
 */
add_action( 'suit_blog_posts_content_loop_after', 'suit_blog_posts_cols_per_row_close', 5 );
add_action( 'suit_blog_posts_content_loop_after', 'suit_blog_posts_navigation', 10 );

/**
 * Entry Content
 *
 * @see suit_blog_posts_content_elements()
 */
add_action( 'suit_blog_posts_entry_content', 'suit_blog_posts_content_elements', 10 );


/* ------------------------------ SINGLE POST ------------------------------ */

/**
 * Entry Content Elements
 *
 * @see suit_blog_post_content_elements()
 */
add_action( 'suit_blog_post_entry_content', 'suit_blog_post_content_elements', 10 );

/**
 * After Post content
 *
 * @see suit_blog_post_after_content_elements()
 */
add_action( 'suit_blog_post_content_after', 'suit_blog_post_after_content_elements', 10 );

/* ------------------------------ SEARCH PAGE ------------------------------ */

/**
 * Entry Header
 *
 * @see suit_blog_search_posts_header()
 */
add_action( 'suit_blog_search_posts_entry_header', 'suit_blog_search_posts_header', 10 );

/**
 * Entry Content
 *
 * @see suit_blog_search_posts_content()
 */
add_action( 'suit_blog_search_posts_entry_content', 'suit_blog_search_posts_content', 10 );

/**
 * Entry Footer
 *
 * @see suit_blog_search_posts_footer()
 */
add_action( 'suit_blog_search_posts_entry_footer', 'suit_blog_search_posts_footer', 10 );




/* ------------------------------ SINGLE PAGE ------------------------------ */

/**
 * Entry Content Elements
 *
 * @see suit_blog_page_content_elements()
 */
add_action( 'suit_blog_page_entry_content', 'suit_blog_page_content_elements', 10 );

/**
 * After Page content
 *
 * @see suit_blog_page_after_content_elements()
 */
add_action( 'suit_blog_page_content_after', 'suit_blog_page_after_content_elements', 10 );

/* ------------------------------ Comments ------------------------------ */

/**
 * Comments
 *
 * @see suit_blog_comments_element()
 */
add_action( 'suit_blog_comments', 'suit_blog_comments_element', 10 );

/* ------------------------------ 404 PAGE ------------------------------ */

/**
 * Entry Content Elements
 *
 * @see suit_blog_404_content_elements()
 */
add_action( 'suit_blog_404_entry_content', 'suit_blog_404_content_elements', 10 );

/* ------------------------------ FOOTER ------------------------------ */

/**
 * Site Content Wrapper End
 *
 * @see suit_blog_site_content_end()
 */
add_action( 'suit_blog_footer_before', 'suit_blog_site_content_end', 10 );


/**
 * Footer Main.
 *
 * @see suit_blog_footer_widgets()
 * @see suit_blog_footer_main()
 */
add_action( 'suit_blog_footer', 'suit_blog_footer_widgets', 5 );
add_action( 'suit_blog_footer', 'suit_blog_footer_main', 10 );

/**
 * After footer.
 *
 * @see suit_blog_footer_back_to_top_button()
 */
add_action( 'suit_blog_footer_after', 'suit_blog_footer_back_to_top_button', 10 );