<?php
/**
 * Add Front Page -> Featured Slider settings.
 *
 * @package Suit Blog
 */

$fields = [
    'front_page_featured_slider_group_settings' => [
        'type'              => 'group-field',
        'section'           => 'hero_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'hero_home_page_enable',
                    'hero_single_pages_enable',
                    'hero_single_posts_enable',
                    'hero_banner_id',
                    'hero_title_sep',
                    'hero_title_typography',
                    'hero_content_sep',
                    'hero_content_typography',
                    'hero_container_backround',
                    'hero_container_sep',
                    'hero_container_height',
                    'hero_container_padding'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'hero_title_sep',
                    'hero_title_md_typography',
                    'hero_content_sep',
                    'hero_content_md_typography',
                    'hero_container_sep',
                    'hero_container_md_height',
                    'hero_container_md_padding'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'hero_title_sep',
                    'hero_title_sm_typography',
                    'hero_content_sep',
                    'hero_content_sm_typography',
                    'hero_container_sep',
                    'hero_container_sm_height',
                    'hero_container_sm_padding'
                ]
            ]
        ],
    ],
    'hero_home_page_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Home Page', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable hero on home page only.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => true,
        'priority'          => 10,
        'partial_refresh'    => [
            'hero_home_page_enable' => [
                'selector'        => '.hero-section .hero-content-wrapper.position-relative .container.position-relative .hero-section',
                'render_callback' => 'suit_blog_hero_section',
            ],
        ],
    ],
    'hero_single_pages_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Single Pages', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable hero on all single pages.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => false,
        'priority'          => 10,
        'partial_refresh'    => [
            'hero_single_pages_enable' => [
                'selector'        => '.hero-section .hero-content-wrapper.position-relative .container.position-relative .hero-section',
                'render_callback' => 'suit_blog_hero_section',
            ],
        ],
    ],
    'hero_single_posts_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Single Posts', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable hero on all single posts.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => false,
        'priority'          => 10,
        'partial_refresh'    => [
            'hero_single_posts_enable' => [
                'selector'        => '.hero-section .hero-content-wrapper.position-relative .container.position-relative .hero-section',
                'render_callback' => 'suit_blog_hero_section',
            ],
        ],
        
    ],
    'hero_banner_id'  => [
        'type'              => 'select',
        'label'             => esc_html__( 'Select Post', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => '1',
	    'multiple'          => 1,
        'choices'           => Kirki_Helper::get_posts( array( 'post_type' => 'post' ) ),
        'priority'          => 10
    ],
    'hero_title_sep' => [
        'type'              => 'custom',
        'section'           => 'hero_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Heading', 'suit-blog' ) . '</h3>',
        'priority'          => 15
    ],
    'hero_title_typography' => [
        'type'              => 'typography',
        'section'           => 'hero_section',
        'priority'          => 15,
        'transport'         => 'auto',
        'default'           => [
            'font-family'       => '',
            'variant'           => '',
            'font-size'         => '',
            'font-style'        => '',
            'line-height'       => '',
            'letter-spacing'    => '',
            'color'             => '',
            'text-transform'    => 'none',
        ],
        'output'            => [
            [
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
        ]
    ],
    'hero_title_md_typography'  => [
        'type'              => 'dimensions',
        'section'           => 'hero_section',
        'default'           => [
            'font-size'         => '',
            'line-height'       => '',
            'letter-spacing'    => '',
        ],
        'choices'           => [
            'labels'            => [
                'font-size'         => esc_html__( 'Font Size', 'suit-blog' ),
                'line-height'       => esc_html__( 'Line Height', 'suit-blog' ),
                'letter-spacing'    => esc_html__( 'Letter Spacing', 'suit-blog' ),
            ],
        ],
        'priority'          => 15,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'font-size',
	            'property'      => 'font-size',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'line-height',
	            'property'      => 'line-height',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'letter-spacing',
	            'property'      => 'letter-spacing',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
        ],
    ],
    'hero_title_sm_typography'  => [
        'type'              => 'dimensions',
        'section'           => 'hero_section',
        'default'           => [
            'font-size'         => '',
            'line-height'       => '',
            'letter-spacing'    => '',
        ],
        'choices'           => [
            'labels'            => [
                'font-size'         => esc_html__( 'Font Size', 'suit-blog' ),
                'line-height'       => esc_html__( 'Line Height', 'suit-blog' ),
                'letter-spacing'    => esc_html__( 'Letter Spacing', 'suit-blog' ),
            ],
        ],
        'priority'          => 15,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'font-size',
	            'property'      => 'font-size',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'line-height',
	            'property'      => 'line-height',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'letter-spacing',
	            'property'      => 'letter-spacing',
                'element'       => '.hero-section .hero-content-details .hero-title',
            ],
        ],
    ],
    'hero_content_sep' => [
        'type'              => 'custom',
        'section'           => 'hero_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Content', 'suit-blog' ) . '</h3>',
        'priority'          => 20
    ],
    'hero_content_typography' => [
        'type'              => 'typography',
        'section'           => 'hero_section',
        'priority'          => 20,
        'transport'         => 'auto',
        'default'           => [
            'font-family'       => '',
            'variant'           => '',
            'font-size'         => '',
            'font-style'        => '',
            'line-height'       => '',
            'letter-spacing'    => '',
            'text-transform'    => 'uppercase',
        ],
        'output'            => [
            [
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
        ]
    ],
    'hero_content_md_typography'  => [
        'type'              => 'dimensions',
        'section'           => 'hero_section',
        'default'           => [
            'font-size'         => '',
            'line-height'       => '',
            'letter-spacing'    => '',
        ],
        'choices'           => [
            'labels'            => [
                'font-size'         => esc_html__( 'Font Size', 'suit-blog' ),
                'line-height'       => esc_html__( 'Line Height', 'suit-blog' ),
                'letter-spacing'    => esc_html__( 'Letter Spacing', 'suit-blog' ),
            ],
        ],
        'priority'          => 20,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'font-size',
	            'property'      => 'font-size',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'line-height',
	            'property'      => 'line-height',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'letter-spacing',
	            'property'      => 'letter-spacing',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
        ],
    ],
    'hero_content_sm_typography'  => [
        'type'              => 'dimensions',
        'section'           => 'hero_section',
        'default'           => [
            'font-size'         => '',
            'line-height'       => '',
            'letter-spacing'    => '',
        ],
        'choices'           => [
            'labels'            => [
                'font-size'         => esc_html__( 'Font Size', 'suit-blog' ),
                'line-height'       => esc_html__( 'Line Height', 'suit-blog' ),
                'letter-spacing'    => esc_html__( 'Letter Spacing', 'suit-blog' ),
            ],
        ],
        'priority'          => 20,
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'font-size',
	            'property'      => 'font-size',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'line-height',
	            'property'      => 'line-height',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'letter-spacing',
	            'property'      => 'letter-spacing',
                'element'       => '.hero-section .hero-content-details .hero-cats-tags>*,.hero-section .hero-content-details .post-meta-wrapper li>*',
            ],
        ],
    ],
    'hero_container_backround'  => [
        'type'              => 'color',
        'label'             => esc_html__( 'Background Color', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => '#ffffff',
        'choices'           => [
            'alpha'         => true,
        ],
        'priority'          => 20,
        'transport'         => 'auto',
        'output'            => [
            [
                'element'   => '.hero-section .hero-content-details',
                'property' => 'background-color',
            ]
        ]
    ],
    'hero_container_sep' => [
        'type'              => 'custom',
        'section'           => 'hero_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Container', 'suit-blog' ) . '</h3>',
        'priority'          => 25
    ],
    'hero_container_height' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Height', 'suit-blog' ),
        'description'       => esc_html__( 'Set container height in PX.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => 490,
        'priority'          => 25,
        'choices'           => [
            'min'               => 300,
            'max'               => 1500,
            'suffix'            => 'px'
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
                'property'      => 'height',
                'suffix'        => 'px'
            ]
        ]
    ],
    'hero_container_md_height' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Height', 'suit-blog' ),
        'description'       => esc_html__( 'Set container height in PX.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => 420,
        'priority'          => 25,
        'choices'           => [
            'min'               => 200,
            'max'               => 1000,
            'suffix'            => 'px'
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
                'property'      => 'height',
                'suffix'        => 'px'
            ]
        ]
    ],
    'hero_container_sm_height' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Height', 'suit-blog' ),
        'description'       => esc_html__( 'Set container height in PX.', 'suit-blog' ),
        'section'           => 'hero_section',
        'default'           => 350,
        'priority'          => 25,
        'choices'           => [
            'min'               => 100,
            'max'               => 800,
            'suffix'            => 'px'
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
                'property'      => 'height',
                'suffix'        => 'px'
            ]
        ]
    ],
    'hero_container_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set container padding.', 'suit-blog' ),
        'section'     => 'hero_section',
        'priority'    => 25,
        'default'     => [
            'padding-top'    => '3rem',
            'padding-bottom' => '3rem',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'padding-top',
	            'property'  => 'padding-top',
                'element'   => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
            [
                'choice'    => 'padding-bottom',
	            'property'  => 'padding-bottom',
                'element'   => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
        ],
    ],
    'hero_container_md_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set container padding.', 'suit-blog' ),
        'section'     => 'hero_section',
        'priority'    => 25,
        'default'     => [
            'padding-top'    => '3rem',
            'padding-bottom' => '3rem',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-top',
	            'property'      => 'padding-top',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-bottom',
	            'property'      => 'padding-bottom',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
        ],
    ],
    'hero_container_sm_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set container padding.', 'suit-blog' ),
        'section'     => 'hero_section',
        'priority'    => 25,
        'default'     => [
            'padding-top'    => '1.5rem',
            'padding-bottom' => '1.5rem',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'       => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom'    => esc_html__( 'Bottom', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-top',
	            'property'      => 'padding-top',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-bottom',
	            'property'      => 'padding-bottom',
                'element'       => '.hero-section .hero-content-wrapper.position-relative .container.position-relative',
            ],
        ],
    ]
    
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );

    Kirki::add_field( 'suit-blog', $field_args );
}